@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Location History','parentTitle'=>'Settings','parentUrl'=>'/settings'])

<div class="wrapper-content">
    <div class="container-fluid">
        @include('settings.history.location-history.partials.filter')
        <div class="ibox">
            <div class="ibox-content">
                <table class="table table-striped nowrap" data-role="ui-data-table" data-url="{{ route('location-history.data') }}" data-searching="false" data-ordering="false" data-page-size="50" data-fixed-header="true">
                    <thead>
                        <th data-col-name="action">Action</th>
                        <th data-col-name="created_at">Date / Time</th>
                        <th data-col-name="ticket_no">Ticket #</th>
                        <th data-col-name="summary">Summary</th>
                        <th data-col-name="modified_by">Modified By</th>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>


@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.history'),'helpTitle'=>config('help-links.help_titles.history')])
@endsection

@section('after_scripts')
@include('reports.scripts.common')
@include('reports.scripts.datatable')
@include('assets.partials.scripts.dropdown-script')

@stop