@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Failed Ticket History','parentTitle'=>'Settings','parentUrl'=>'/settings'])

<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="ibox">
            
            <div class="ibox-content">
                
                <div class="ibox-tools">
                    
                    <a href="#" id="export-csv" class="btn btn-primary">Export to CSV</a>
                    
                </div>
                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                
                <table class="footable table table-stripped table-hover nowrap" data-page-size="50" data-filter=#filter>
                    
                    <thead>
                        
                        <tr>
                            <th>#</th>
                            <th>Ticket # </th>
                            <th>Created At</th>
                            <th>User Name</th>
                            <th>Description</th>
                        </tr>
                    </thead>
                    
                    <tbody>
                        
                    </tbody>
                    
                </table>
                
            </div>
            
        </div>
        
    </div>
    
</div>


@stop

@section('after_scripts')

<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/dataTables/dataTables.fixedHeader.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script>
    
    $(document).ready(function() {
        
        var table = $('.footable').DataTable({
            responsive: true,
            scrollCollapse: true,
            scrollX: true,
            scrollY: false,
            "processing": true,
            "serverSide": true,
            "ajax":{
                "url": "{{ route('failed-tickets-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function( result ) {
                }
            },
            "columns": [
            { "data": "id" },
            { "data": "ticket" },
            { "data": "created_at" },
            { "data": "user_name" },
            { "data": "description" }
            ],
            lengthMenu: [
            [ 50, 100, 200],
            [ '50', '100', '200']
            ],
            columnDefs: [
            { orderable: false, targets: [0, 1, 2, 3, 4] }
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
            fixedHeader: {
                header: true,
            }
            
        });
        
        
        $('#export-csv').on('click', function(e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({  
                type: "POST",  
                url: "/failed-ticket-history-export",  
                dataType: 'text',
                success: function(result) {
                    var blob = new Blob([result]);
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                    window.navigator.msSaveBlob(blob, "failed-ticket-history.csv");
                    else
                    {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, {type: "text/plain"});
                        a.download = "failed-ticket-history.csv";
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });
        
    });
</script>
@stop
