@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => "API History - Blocked IP Addresses",'parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        @include('settings.history.api-blocked-ips.partials.filter')
        @include('settings.partials.success-message')
        @include('settings.partials.success')
        <div class="ibox">
            <div class="ibox-content">
                <table class="footable footable-fixed-header table table-stripped table-hover" data-role="ui-data-table" data-url="{{ route('api-blocked-ips.data') }}" data-searching="false" data-ordering="false" data-page-size="50" data-fixed-header="true">
                    <thead>
                        <tr>
                            <th data-col-name="id">#</th>
                            <th data-col-name="ip">IP</th>
                            <th data-col-name="blocked_at">Blocked At</th>
                            <th data-col-name="action"></th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>

@include('settings.history.api-blocked-ips.modals.unblock-ip-modal')
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.developers'),'helpTitle'=>config('help-links.help_titles.developers')])
@endsection

@section('after_scripts')
@include('reports.scripts.common')
@include('reports.scripts.datatable')
@include('settings.history.api-blocked-ips.partials.api-blocked-ips-scripts')
@stop