@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'HiBob Credential','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">

                <div class="ibox">

                    <div class="ibox-content">

                        @include('partials.success')
                        @include('partials.error-message')

                        @include('settings.partials.delete-message')
                        @include('partials.sync-messages')

                        <table class="footable table table-stripped" data-page-size="50" data-filter=#filter id="api-credential-table">

                            <thead>

                                <tr>
                                    <th>#</th>
                                    <th>Connect</th>
                                    <th>Status</th>
                                    <th>Edit</th>
                                    <th>Sync</th>
                                </tr>

                            </thead>

                            <tbody>

                            @if($credentials)
                                <tr>
                                    <td>1</td>
                                    <td>
                                        <a href="{{route('hibob.connect')}}" class="btn btn-primary btn-sm">Connect</a>
                                    </td>
                                    <td>
                                        @if ($status == 1)
                                        <button class="btn btn-primary btn-sm" disabled="disabled">Active</button>
                                        @else
                                        <button class="btn btn-danger btn-sm" disabled="disabled">Inactive</button>
                                        @endif
                                    </td>
                                    <td>@can('API Credentials Edit')<a href="{{route('hibob.edit', ['hibob' => $credentials->id])}}"><i class="icon icon-n-edit"></i></a>@endcan</td>
                                    <td>
                                        @if ($status != 0)
                                        <button class="btn btn-primary btn-sm" id="manual-sync">Manual Sync</button>
                                        <button class="btn btn-primary btn-sm" id="manual-sync2" disabled
                                            style="display: none;"><i class="icon icon-reload icon-is-spinning"></i></button>
                                        @else
                                        <button class="btn btn-primary btn-sm" disabled>Manual Sync</button>
                                        @endif
                                    </td>
                                </tr>
                            @else
                                <tr>
                                    <td colspan="7">No Api Credentials in the system.</td>
                                </tr>
                            @endif

                            </tbody>

                            <tfoot>

                                <tr>

                                    <td colspan="7">

                                        <ul class="pagination pull-right"></ul>

                                    </td>

                                </tr>

                            </tfoot>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>


@stop
@section('after_scripts')
<script>
$("#manual-sync").click(function (e) {
        e.preventDefault();
        $(".sync-msg").hide();
        $("#sync-success-msg").html('HiBob import started. Please wait. It may take a while.');
        $("#sync-success").show();
        $('#manual-sync').hide();
        $('#manual-sync2').show();
        $.ajax({
            type: "POST",
            url: "/hibob-sync",
            success: function (data) {
                $(".sync-msg").hide();
                $("#sync-success-msg").html('');
                $('#manual-sync2').hide();
                if (data.status == 'success') {
                    $("#sync-success-msg").html(data.message);
                    $("#sync-success").show();
                } else {
                    $("#sync-error-msg").html(data.message);
                    $("#sync-error").show();
                }

                $('#manual-sync').show();
            }
        }).fail(function () {
            $(".sync-msg").hide();
            $('#manual-sync').show();
            $('#manual-sync2').hide();
            $("#sync-error-msg").html('Error while syncing. Please try again.');
            $("#sync-error").show();
        });
    });
</script>
@stop