@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Edit HiBob Credential', 'parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">

                <div class="ibox">

                    <div class="ibox-content">

                        @include('partials.success')
                        @include('partials.error-message')

                        @include('settings.partials.delete-message')

                        <form class="form-horizontal" method="post" action="{{route('hibob.update', ['hibob' => $credential->id])}}"">

                            {{csrf_field()}}

                            @method('PUT')

                            <div class="row">

                                @include('partials.error')

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="col-lg-3 control-label">Service User ID</label>
                                        <div class="col-lg-6">
                                            <input type="text" class="form-control" name="user_name" value="{{$credential->user_name}}" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-3 control-label">Service User Token</label>
                                        <div class="col-lg-6">
                                            <input type="text" class="form-control" name="password" value="">
                                            <span class="help-block m-b-none">To keep the old User Token, leave this empty</span>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <div class="col-lg-offset-3 col-lg-1">
                                            <button class="btn btn-primary" name="commit" type="submit">Save</button>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </form>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

@stop

@section('after_scripts')
    @include('assets.partials.scripts.common')
@stop