@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Create HiBob Credential', 'parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">

                <div class="ibox">

                    <div class="ibox-content">

                        @include('partials.success')
                        @include('partials.error-message')

                        @include('settings.partials.delete-message')

                        <form class="form-horizontal" method="post" action="/hibob">

                            {{csrf_field()}}

                            <div class="row">

                                @include('partials.error')

                                <div class="col-lg-12">

                                    <div class="form-group">
                                        <label class="col-lg-3 control-label">Service User ID</label>
                                        <div class="col-lg-6">
                                            <input type="text" class="form-control" name="user_name" value="{{old('user_name')}}" required>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-3 control-label">Service User Token</label>
                                        <div class="col-lg-6">
                                            <input type="text" class="form-control" name="password" value="{{old('password')}}" required>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <div class="col-lg-offset-3 col-lg-1">
                                            <button class="btn btn-primary" name="commit" type="submit">Save</button>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </form>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

@stop

@section('after_scripts')
    @include('assets.partials.scripts.common')
@stop