@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Hardware
Standard','parentTitle'=>'Settings','parentUrl'=>'/settings'])

<div class="wrapper-content">
    <div class="container-fluid">

        @include('settings.hardware-standard.filter-hardware')
        <div class="ibox dt-table-wrap-ibox">
            <div class="ibox-content">

                @include('partials.success')
                @include('partials.error-message')
                @include('settings.partials.success-message')
                @include('settings.partials.delete-message')
                <div class="row form-group">
                    <div class="col-lg-6">
                        <p class="pull-left help-block">Life of Assets : 4 years</p>
                    </div>
                    <div class="col-lg-6">
                        <div class="ibox-title">
                
                            <div class="ibox-tools">
                                
                                <a href="#" id="export-csv" class="btn btn-primary">Export to CSV</a>
                                @can('Hardware Standards & Technical Specs Edit')
                                <a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html"
                                    data-target="#addHardwareStandard">Add New</a>
                                <a href="/bulk-hardware-standards" class="btn btn-primary" >Bulk Create / Update</a>
                                @endcan
                                <button id="bulkDeleteButton" class="btn btn-danger " style="display: none;">Delete Selected</button>
                            </div>
                            
                        </div>
                    </div>
                </div>



                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                <div class="form-group" style="display: inline-block;">
                    <label>Show entries:</label>
                    <select class="form-control" id="pageLengthSelect">
                        <option value="25" @if(25 == config('pagination.per_page')) selected @endif>25</option>
                        <option value="50" @if(50 == config('pagination.per_page')) selected @endif>50</option>
                        <option value="100" @if(100 == config('pagination.per_page')) selected @endif>100</option>
                        <option value="200" @if(200 == config('pagination.per_page')) selected @endif>200</option>
                    </select>
                </div>
                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                    id="hardware-standard-table">

                    <thead>

                        <tr>
                            <th style="display:none;" data-visible="false"></th>

                            <th style="display:none;" data-visible="false"></th>

                            <th width="5%"><input type="checkbox" name="checkall" id="checkAll"></th>

                            <th width="10%">#</th>

                            <th width="20%" class="th-sortable">Asset Type</th>

                            <th width="20%" class="th-sortable">Manufacturer</th>

                            <th width="30%" class="th-sortable">Hardware Standard</th>

                            <th width="15%" class="th-sortable"># of Assets</th>

                        </tr>

                    </thead>

                    <tbody>

                        @include('settings.hardware-standard.hardware-standard-data')

                    </tbody>

                    <tfoot>

                        <tr class="p-links">
                            @include('settings.hardware-standard.hardware-standard-pagination-links')

                        </tr>

                    </tfoot>

                </table>

            </div>

        </div>
    </div>

</div>


<div class="modal inmodal" id="addHardwareStandard" tabindex="-1" role="dialog">

    <div class="modal-dialog">

        <div class="modal-content animated fadeIn">

            <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal"><span>×</span><span
                        class="sr-only">Close</span></button>

                <h4 class="modal-title">Add New Hardware Standard</h4>

            </div>

            <div class="modal-body">

                @include('partials.error')

                <form class="form-horizontal" action="" method="post" id="hardware-standard-form">

                    {{csrf_field()}}

                    <div class="form-group">

                        <label class="col-lg-4 control-label">Asset Type</label>

                        <div class="col-lg-8">

                            <select class="form-control" id="assettypes" name="assettype" required>
                                <option value="">Select</option>
                                @foreach(\App\Models\AssetType::orderBy('slug')->get() as $assettype)
                                @if($assettype->name!='Computer Accessories')
                                <option value="{{$assettype->id}}">{{$assettype->name}}</option>
                                @endif
                                @endforeach
                            </select>

                        </div>

                    </div>

                    <div class="form-group">

                        <label class="col-lg-4 control-label">Manufacturer</label>

                        <div class="col-lg-8">

                            <select class="form-control" id="manufacturer" name="manufacturer" required>
                                <option value="">Select</option>
                                @foreach(\App\Models\Manufacturer::orderBy('slug')->get() as $manufacturer)
                                <option value="{{$manufacturer->name}}">{{$manufacturer->name}}</option>
                                @endforeach
                            </select>

                        </div>

                    </div>


                    <div class="form-group">

                        <label class="col-lg-4 control-label">Hardware Standard</label>

                        <div class="col-lg-8">

                            <input type="text" class="form-control make_model" name="make_model"
                                value="{{old('make_model')}}" required>

                        </div>

                    </div>

                </form>

            </div>

            <div class="modal-footer">

                <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>

                <button type="button" class="btn btn-primary" id="submit">Save</button>

            </div>

        </div>

    </div>

</div>

@include('settings.modals.confirm-delete')

@stop

@section('after_scripts')

@include('settings.hardware-standard.hardware-standard-script')

@stop