<script src="/js/plugins/tabledit/tabledit-modified.js"></script>
<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>

<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/dataTables/dataTables.fixedHeader.min.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/sweetalert2.all.min.js"></script>
<script>

    @if ($errors -> count() > 0)
        $("#addHardwareStandard").modal({ show: true });
    @endif

    $(document).ready(function () {
        $('.modal').on('show.bs.modal', function (e) {
            $(".alert-danger").hide();
        });

        $('.chosen-select').chosen({ width: "100%" });
        // Check/uncheck all checkboxes when the checkbox in the table header is clicked
        $('#checkAll').on('click', function () {
            var isHeaderCheckboxDisabled = $(this).is(':disabled');
            if (!isHeaderCheckboxDisabled) {
                $('.checkRow:not(:disabled)').prop('checked', $(this).prop('checked'));
                toggleActionButtonVisibility();
            }
        });

        // Click event for individual checkboxes in the table body
        $('#hardware-standard-table tbody').on('click', '.checkRow', function () {
            var isIndividualCheckboxDisabled = $(this).is(':disabled');
            if (!isIndividualCheckboxDisabled) {
                var allChecked = $('.checkRow:not(:disabled):checked').length === $('.checkRow:not(:disabled)').length;
                $('#checkAll').prop('checked', allChecked);
                toggleActionButtonVisibility();
            }
        });

        function toggleActionButtonVisibility() {
            var checkedValues = [];
            $('#bulkDeleteButton').hide();
            $('.checkRow:checked:not(:disabled)').each(function () {
                var value = $(this).val();
                if (!checkedValues.includes(value)) {
                    $('#bulkDeleteButton').show();
                    return;
                }
            });
        }

        $(document).on('click', '#bulkDeleteButton', function (e) {
            e.preventDefault();
            $('#confirm-delete').modal('show');
            $('#confirm-message').html('Are you sure you want to delete?');
        });

        $(".confirm-delete-button").on("click", function (e) {
            e.preventDefault();
            var checkedValues = [];
            $('.checkRow:checked:not(:disabled)').each(function () {
                var value = $(this).val();
                if (!checkedValues.includes(value)) {
                    checkedValues.push(value);
                }else {
                    return false; // Exit the loop on the first duplication
                }
            });
            if(checkedValues.length > 0) {

                $('.ajax-loader').show();
                $.ajax({
                    type: "POST",
                    url: "/hardware-standard-bulk-delete",
                    data: { hardware_ids:checkedValues },
                    success: function (data) {
                        $('.ajax-loader').hide();
                        $('#confirm-delete').modal('hide');
                        $('#bulkDeleteButton').hide();
                        if (data == 'deleted') {
                            $('#success').show();
                            $('#success p').text("Hardware Standard deleted successfully.");
                        } else if (data == 'error') {
                            $('#error').show();
                            $('#error p').text("This hardware standard cannot be deleted as it has assets associated with it.");
                        }
                        $('html, body').animate({
                            scrollTop: $("#success").offset().top
                        }, 1000);

                        $('#hardware-filter-form').submit();
                    }
                })
            }

        });

        $('#submit').click(function () {
            $("#pageNo").val(1);
            $('#hardware-standard-form').submit();
        });

        $("#manufacturer_id").on('change', function () {
            $("#pageNo").val(1);
            $('#hardware-filter-form').submit();
        });

        $(document).on('click', '.pagination a', function (event) {
            event.preventDefault();
            var page = $(this).attr('href').split('page=')[1];
            $("#pageNo").val(page);
            $('#hardware-filter-form').submit();
        });

        $('#pageLengthSelect').on('change', function() {
            $("#pageNo").val(1);
            $('#hardware-filter-form').submit();
        });

        var sortingColumn = '';
        var sortingDirection = 'asc';
        // Bind the event to the click of the th elements
        $('#hardware-standard-table thead .th-sortable').on('click', function (event) {
            event.preventDefault();
            sortableIndexes = [2,3,4,5];
            var columnIndex = $(this).index();
            if (sortableIndexes.indexOf(columnIndex) === -1) {
                return; // If the columnIndex is not present in sortableIndexes, do not continue execution
            }
            var currentOrder = sortingColumn === columnIndex ? (sortingDirection === 'asc' ? 'desc' : 'asc') : 'asc';

            // Update the classes responsible for the sorting icon in the table header
            $('#hardware-standard-table thead th')
            .removeClass('sorting_desc sorting_asc')
            .addClass('sorting');

            if (currentOrder === 'asc') {
            $(this).removeClass('sorting').addClass('sorting_asc');
            } else {
            $(this).removeClass('sorting').addClass('sorting_desc');
            }

            // Update the sortingColumn and sortingDirection variables
            sortingColumn = columnIndex;
            sortingDirection = currentOrder;

            // Submit the form with the updated sortingColumn and sortingDirection values
            $('#hardware-filter-form').trigger('submit');
        });

        $('#hardware-filter-form').submit(function (e) {
            e.preventDefault();
            $('#checkAll').prop('checked', false);
            var page = $("#pageNo").val();
            var pageLength = $("#pageLengthSelect").val();
            $('.ajax-loader').show();
            var formData = $(this).serializeArray();
            $('#asset_type').prop("disabled", true).trigger("chosen:updated");
            $('#manufacturer_id').prop("disabled", true).trigger("chosen:updated");

            $.ajax({
                type: "POST",
                url: "/hardware-standard-search?page=" + page+'&page_legth='+pageLength+'&sort_column='+sortingColumn+'&sort_direction='+sortingDirection,
                data: formData,
                success: function (value) {
                    $('.ajax-loader').hide();
                    var dataTable = $("#hardware-standard-table").DataTable();

                    // get the html table rows then
                    if ($.fn.DataTable.isDataTable('#hardware-standard-table')) {
                        dataTable.clear();
                        dataTable.destroy();
                    }

                    $("tbody").empty().promise().done(function () {
                        $("tbody").html(value.hardware);
                        $(".p-links").html(value.links);
                    });

                    toggleActionButtonVisibility();

                    $('#hardware-standard-table').Tabledit({
                        url: '/hardware-standard-ajax',
                        columns: {
                            identifier: [1, 'make_and_model_id'],
                            editable: [[4, 'assettype', 'select', JSON.stringify({!!$assettypes!!})], [5, 'manufacturer_name', 'select', JSON.stringify({!!$manufacturers!!})], [6, 'make_model_name']]
        },
            warningClass: 'success',
            mutedClass: 'danger',
            onDraw : function (data) {
                var status = value.status;
                $('#hardware-standard-table tbody').find('tr').each(function (index) {
                    if (status[index]) {
                        if (status[index].status == 1) {
                            $(this).find('.btn-group').find('.tabledit-status-button').html('<span class="icon icon-check-single"></span>');
                            $(this).find('.btn-group').find('.tabledit-status-button').removeClass('btn-danger').addClass('btn-primary');
                        } else {
                            $(this).find('.btn-group').find('.tabledit-status-button').html('<span class="icon icon-s-remove"></span>');
                            $(this).find('.btn-group').find('.tabledit-status-button').removeClass('btn-primary').addClass('btn-danger');
                        }
                    }
                });
            },
            onSuccess: function (data) {
                // $('.alert-success').alert('close');
                if (data.status == 1) {
                    $(":focus").children('span').removeClass('glyphicon-remove');
                    $(":focus").children('span').addClass('glyphicon-ok');
                    $(":focus").removeClass('btn-danger').addClass('btn-primary');
                } else {
                    $(":focus").children('span').removeClass('glyphicon-ok');
                    $(":focus").children('span').addClass('glyphicon-remove');
                    $(":focus").removeClass('btn-primary').addClass('btn-danger');
                }
                $('.ajax-messages').hide();
                if (data == 'success') {
                    $('#success').show();
                    $('#success p').text("Hardware Standard updated successfully.");
                }
                else if (data == 'deleted') {
                    $('#success').show();
                    $('#success p').text("Hardware Standard deleted successfully.");
                } else if (data == 'error') {
                    $('#error').show();
                    $('#error p').text("This hardware standard cannot be deleted as it has assets associated with it.");
                }
                // Check if data is an object (dictionary)
                else if (typeof data === "object" && data.hasOwnProperty("success") && data.success === "success") {
                    $('#success').show();
                    $('#success p').text(data.message);
                } else if (data == 'failed') {
                    $('#error').show();
                    $('#error p').text("Operation failed.");
                }
                $('html, body').animate({
                    scrollTop: $("#success").offset().top
                }, 1000);
            },
            restoreButton : false
                    });

                },
    error: function(value) {

    }
            })
            .done(function () {
        $('#asset_type').prop("disabled", false).trigger("chosen:updated");
        $('#manufacturer_id').prop("disabled", false).trigger("chosen:updated");
        $('#hardware-standard-table').DataTable(
            {

                lengthMenu: [
                    [50, 100, 200],
                    ['50', '100', '200']
                ],
                fixedHeader: {
                    header: true,
                },
                // "order": [[2, "asc"]],
                "columnDefs": [
                    { "orderable": true, "targets": [4,5,6,7] },
                    { "orderable": false, "targets": [0,2,3,8] }
                ],
                "bFilter": false,
                "bLengthChange": false,
                "bInfo": false,
                "paging": false
            }
        );
    });

        });

    @can('Hardware Standards & Technical Specs Edit')
    $('#hardware-standard-table').Tabledit({
        url: '/hardware-standard-ajax',
        columns: {
            identifier: [1, 'make_and_model_id'],
            editable: [[4, 'assettype', 'select', JSON.stringify({!!$assettypes!!})], [5, 'manufacturer_name', 'select', JSON.stringify({!!$manufacturers!!})], [6, 'make_model_name']]
            },
    warningClass: 'success',
        mutedClass: 'danger',
            onDraw: function(data) {
                var status = {!!$status!!};

    $('#hardware-standard-table tbody').find('tr').each(function (index) {

        if (status[index].status == 1) {
            $(this).find('.btn-group').find('.tabledit-status-button').html('<span class="icon icon-check-single"></span>');
            $(this).find('.btn-group').find('.tabledit-status-button').removeClass('btn-danger').addClass('btn-primary');
        } else {
            $(this).find('.btn-group').find('.tabledit-status-button').html('<span class="icon icon-s-remove"></span>');
            $(this).find('.btn-group').find('.tabledit-status-button').removeClass('btn-primary').addClass('btn-danger');
        }
    });
            },
    onSuccess: function(data) {
        // $('.alert-success').alert('close');
        if (data.status == 1) {
            $(":focus").children('span').removeClass('glyphicon-remove');
            $(":focus").children('span').addClass('glyphicon-ok');
            $(":focus").removeClass('btn-danger').addClass('btn-primary');
        } else {
            $(":focus").children('span').removeClass('glyphicon-ok');
            $(":focus").children('span').addClass('glyphicon-remove');
            $(":focus").removeClass('btn-primary').addClass('btn-danger');
        }

        $('.ajax-messages').hide();
        if (data == 'success') {
            $('#success').show();
            $('#success p').text("Hardware Standard updated successfully.");
        }
        else if (data == 'deleted') {
            $('#success').show();
            $('#success p').text("Hardware Standard deleted successfully.");
        } else if (data == 'error') {
            $('#error').show();
            $('#error p').text("This hardware standard cannot be deleted as it has assets associated with it.");
        }
        // Check if data is an object (dictionary)
         else if (typeof data === "object" && data.hasOwnProperty("success") && data.success === "success") {
            $('#success').show();
            $('#success p').text(data.message);
        } else if (data == 'failed') {
            $('#error').show();
            $('#error p').text("Operation failed.");
        }
        $('html, body').animate({
            scrollTop: $("#success").offset().top
        }, 1000);

    },
    restoreButton: false
        });

    @endcan

    $.fn.serializeObject = function () {
        var obj = {};

        $.each(this.serializeArray(), function (i, o) {
            var n = o.name, v = o.value;

            obj[n] = obj[n] === undefined ? v
                : $.isArray(obj[n]) ? obj[n].concat(v)
                    : [obj[n], v];
        });

        return obj;
    };

    $('#export-csv').on('click', function (e) {
        e.preventDefault();
        $('.ajax-loader').show();
        $.ajax({
            type: "POST",
            url: "/hardware-standard-export",
            data: $('#hardware-filter-form').serializeObject(),
            dataType: 'text',
            success: function (result) {
                var blob = new Blob([result]);
                if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                    window.navigator.msSaveBlob(blob, "hardware-standards.csv");
                else {
                    var a = window.document.createElement("a");
                    a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
                    a.download = "hardware-standards.csv";
                    document.body.appendChild(a);
                    a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                    document.body.removeChild(a);
                }
                $('.ajax-loader').hide();
            }
        })
    });

    var dataTable = $('#hardware-standard-table').DataTable(
        {

            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            fixedHeader: {
                header: true,
            },
            // "order": [[2, "asc"]],
            "columnDefs": [
                    { "orderable": true, "targets": [4,5,6,7] }, // Enable sorting on columns 2 (Asset Type) and 3 (Manufacturer)
                    { "orderable": false, "targets": [0,2,3,8] } // Disable sorting on other columns
                ],
            "bFilter": false,
            "bLengthChange": false,
            "bInfo": false,
            "paging": false
        }
    );

    $("#asset_type").change(function () {
        $("#pageNo").val(1);
        $.ajax({
            type: "POST",
            data: { id: $(this).val() },
            url: "/assets-filter/list-manufacturer",
            success: function (data) {
                $('#manufacturer_id').empty().trigger('chosen:updated');

                $.each(data, function (key, value) {
                    $('#manufacturer_id').append($('<option>', {
                        value: value.id,
                        text: value.manufacturer
                    })).trigger('chosen:updated');
                })

            }
        }).done(function () {
            $('#hardware-filter-form').submit();
        });
    });

    });

</script>