@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'G Suite','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="ibox">
            
            <div class="ibox-content">
                
                <!-- <p><a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html" data-target="#addApiCredential">Add New</a></p> -->
                @include('partials.error-message')
                @include('partials.success')
                @include('partials.sync-messages')
                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter id="api-credential-table">

                    <thead>

                        <tr>
                            <tr>
                                <th>Name</th>
                                <th>Status</th>
                                <th>Sync</th>
                                <th></th>
                            </tr>
                        </tr>

                    </thead>

                    <tbody>

                        <tr>

                            <td>GSuite Locations</td>
                            <td>@if ($status == 1)
                                <button class="btn btn-primary btn-sm" disabled="disabled">Active</button>
                                @else
                                <button class="btn btn-danger btn-sm" disabled="disabled">Inactive</button>
                                @endif
                            </td>

                            <td>
                                @if ($status == 1)
                                <button type="button" class="btn btn-primary manual-sync-buttons" id="gsuite-sync">Manual Sync</button>
                                @endif
                            </td>
                            
                            <td> @can('API Credentials Edit')
                                <a href="/gsuite-locations/edit"><i class="icon icon-n-edit"></i></a>
                                @endcan
                            </td>
                        </tr>

                    </tbody>

                    <tfoot>

                        <tr>

                            <td colspan="4">

                                <ul class="pagination pull-right"></ul>

                            </td>

                        </tr>

                    </tfoot>

                </table>
                
                {{-- <span class="sync-msg">G Suite locations are synced automatically every DAY at
                01 AM</span> --}}
            </div>
            
        </div>
        
    </div>
    
</div>
    
    
@stop

@section('after_scripts')
@include('settings.partials.responsive-fixedheader')
<script>
    
    $('#connect-button').click(function () {
        $('#connect-form').show();
    });
    
    $('#sync-button').click(function () {
        $('#sync-button').attr("disabled", true);
    });
    
    $("#gsuite-sync").click(function (e) {
        e.preventDefault();
        $(".manual-sync-buttons").attr("disabled", true);
        $('#gsuite-sync').html('Google Locations syncing.').attr("disabled", true);
        $("#sync-success").hide();
        $("#sync-success").html('Google Locations sync started. Please wait. It may take a while.').show();
        $.ajax({
            type: "post",
            url: "/gsuite-locations/manual-sync",
            success: function (data) {
                $(".manual-sync-buttons").attr("disabled", false);
                $('#gsuite-sync').html('Manual Sync');
                $("#sync-success").hide();
                $('#gsuite-sync2').hide();
                if (data.status == 'success') {
                    $("#sync-success").html(data.message).show();
                } else {
                    $("#sync-error").html(data.message).show();
                }
                
                $('#gsuite-sync').show();
            }
        });
    });

</script>
    
@stop