@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Freshservice','parentTitle' => 'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="ibox">
            
            <div class="ibox-content">
                
                <!-- <p><a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html" data-target="#addApiCredential">Add New</a></p> -->
                @include('partials.error-message')
                @include('partials.success')
                
                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                id="api-credential-table">
                
                <thead>
                    
                    <tr>
                        <th>#</th>
                        <th>Status</th>
                        <th>Name</th>
                        <th>URL</th>
                        <th></th>
                    </tr>
                    
                </thead>
                
                <tbody>
                    
                    @if($apiCredential)
                    <tr>
                        <td>1</td>
                        <td>@if ($status == 1)
                            <button class="btn btn-primary btn-sm" disabled="disabled">Active</button>
                            @else
                            <button class="btn btn-danger btn-sm" disabled="disabled">Inactive</button>
                            @endif
                        </td>
                        <td>{{$apiCredential->api_name}}</td>
                        <td>{{$apiCredential->url}}</td>
                        <td>@can('API Credentials Edit')<a
                            href="{{route('freshservice.edit', ['freshservice' => $apiCredential->id])}}"><i
                            class="icon icon-n-edit"></i></a>@endcan
                        </td>
                    </tr>
                    @else
                    <tr>
                        <td colspan="5">No API Credentials in the system.</td>
                    </tr>
                    @endif
                        
                    </tbody>
                    
                    <tfoot>
                        
                        <tr>
                            
                            <td colspan="5">
                                
                                <ul class="pagination pull-right"></ul>
                                
                            </td>
                            
                        </tr>
                        
                    </tfoot>
                    
                </table>
                
            </div>
            
        </div>
        
    </div>
    
</div>


@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection

@section('after_scripts')
@include('settings.partials.responsive-fixedheader')
@stop