@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Add Freshservice Credential', 'parentSubUrl' => '/freshservice', 'parentSubTitle'
=> 'Freshservice','parentTitle' => 'Settings','parentUrl'=>'/settings'])

<div class="wrapper-content">

    <div class="container-fluid">

    	<form class="form-horizontal" method="post" action="{{route('freshservice.store')}}">

    		{{csrf_field()}}

	        <div class="ibox">
				@include('partials.error')
				@include('partials.success')

				<div class="ibox-content">
					
					<div class="form-group">
						<label class="col-lg-3 control-label">URL</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="url" value="{{ old('url') }}" required>
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">API Key</label>
						<div class="col-lg-6">
							<input type="password" class="form-control" name="key" value="{{ old('key') }}" required>
						</div>
					</div>

					<div class="form-group">
						<div class="col-lg-offset-3 col-lg-1">
							<button class="btn btn-primary" name="commit" type="submit">Save</button>
						</div>
							
					</div>

				</div>

		        
		    </div>
		</form>

	</div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection

@section('after_scripts')
    @include('assets.partials.scripts.common')
@stop