@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'FedEx Tracking Credential','parentTitle' => 'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">

        <div class="ibox">

            <div class="ibox-content">

                @include('partials.success')
                @include('partials.error-message')

                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter id="api-credential-table">

                    <thead>

                        <tr>
                            <th>#</th>
                            <th>URL</th>
                            <th>Password</th>
                            <th>Access Key</th>
                            <th>Meter Number</th>
                            <th>Account Number</th>
                            <th></th>
                        </tr>

                    </thead>

                    <tbody>

                        @if($credentials)
                        <tr>
                            <td>1</td>
                            <td>{{ $credentials->url }}</td>
                            <td>*****</td>
                            <td>*****</td>
                            <td>{{ $credentials->account_no }}</td>
                            <td>{{ $credentials->meter_no }}</td>
                            <td>
                                @can('API Credentials Edit')
                                <a href="/fedex-tracking-api/{{$credentials->id}}/edit"><i class="icon icon-n-edit"></i></a>
                                @endcan
                            </td>
                        </tr>
                        @else
                        <tr>
                            <td colspan="7">No Api Credentials in the system.</td>
                        </tr>
                        @endif

                    </tbody>

                    <tfoot>

                        <tr>
                            <td colspan="7">

                            </td>

                        </tr>

                    </tfoot>

                </table>

                <div class="row">
                    <div class="col-md-12">
                        <form method="post" action="/fedex-tracking-api/manual-sync" class="form-inline">
                            @csrf
                            <button class="btn btn-primary col-md-2" type="button" id="manual-sync">Manual Sync</button>
                            <span class="text-danger col-md-10" id="sync-error"></span>
                            <span class="text-success col-md-10" id="sync-success"></span>
                        </form>
                    </div>
                </div>

            </div>

        </div>

    </div>

</div>


@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection

@section('after_scripts')
@include('settings.partials.responsive-fixedheader')
<script>
    $(function () {
        $("#manual-sync").click(function () {
            $("#manual-sync").attr("disabled", true);
            $("#sync-success").html('<div class="alert alert-warning">Manual sync started. Please wait. It may take a while.</div>');
            $.ajax({
                type: "POST",
                url: "/fedex-tracking-api/manual-sync",
                success: function(data) {
                    $("#sync-success").html('<div class="alert alert-success">Manual sync completed. Count of updated assets <a class="alert-link">'+data+'</a></div>');
                    $('#manual-sync').attr("disabled", false);
                },
                error: function(value) {
                    $("#sync-success").html('');
                    $("#sync-error").html('<div class="alert alert-danger">Error occurred in API connection.</div>');
                    $('#manual-sync').attr("disabled", false);
                }
            });
        });
    });
</script>
@endsection