@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Edit FedEx Tracking Credential','parentSubTitle' => 'FedEx Tracking Credential','parentSubUrl'=>'/fedex-tracking-api',
'parentTitle' => 'Settings','parentUrl'=>'/settings'])

<div class="wrapper-content">

    <div class="container-fluid">
    	<div class="ibox">
			@include('partials.error')
			<div class="ibox-content ibox-content-settings">

				<form class="form-horizontal" method="post" action="/fedex-tracking-api/{{$credential->id}}">

						{{csrf_field()}}

						@method('PUT')

					<div class="form-group">
						<label class="col-lg-3 control-label">URL</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="url" value="{{$credential->url}}">
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">Password</label>
						<div class="col-lg-6">
							<input type="password" class="form-control" name="password" value="">
							<span class="help-block m-b-none">To keep the old password, leave this empty</span>
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">Access key</label>
						<div class="col-lg-6">
							<input type="password" class="form-control" name="key" value="">
							<span class="help-block m-b-none">To keep the old access key, leave this empty</span>
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">Meter number</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="meter_no" value="{{ $credential->meter_no }}">
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">Account number</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="account_no" value="{{ $credential->account_no }}">
						</div>
					</div>

					<div class="form-group">
						<div class="col-lg-offset-3 col-lg-1">
							<input type="hidden" class="form-control" name="user_name" value="{{$credential->user_name}}">
							<button class="btn btn-primary" name="commit" type="submit">Save</button>
						</div>
					</div>
				
				</form>	
			</div>

		</div>

	</div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection

@section('after_scripts')
    @include('assets.partials.scripts.common')
@stop