@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Create FedEx Tracking Credential','parentSubTitle' => 'FedEx Tracking Credential','parentSubUrl'=>'/fedex-tracking-api',
'parentTitle' => 'Settings','parentUrl'=>'/settings'])

<div class="wrapper-content">
	<div class="container-fluid">
		<div class="ibox">
			<div class="ibox-content ibox-content-settings">
				
				@include('partials.error')
				
				<form class="form-horizontal" method="post" action="{{route('fedex-tracking-api.store')}}">

					{{csrf_field()}}

					<div class="form-group">
						<label class="col-lg-3 control-label">URL</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="url" value="">
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">Username</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="user_name" value="">
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">Password</label>
						<div class="col-lg-6">
							<input type="password" class="form-control" name="password" value="">
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">Access key</label>
						<div class="col-lg-6">
							<input type="password" class="form-control" name="key" value="">
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">Meter number</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="meter_no" value="">
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">Account number</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="account_no" value="">
						</div>
					</div>

					<div class="form-group">
						<div class="col-lg-offset-3 col-lg-1">
							<button class="btn btn-primary" name="commit" type="submit">Save</button>
						</div>
					</div>

				</form>
				
			</div>
		</div>
	</div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection

@section('after_scripts')
@include('assets.partials.scripts.common')
@stop