@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'EOL Certificate - Bulk Upload
Individual','parentTitle'=>'Toolbox','parentUrl'=>'/toolbox'])
<style type="text/css">
    .dz-error-message {
        display: none !important;
    }
</style>


<div class="wrapper-content eol-certificates-upload">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-3">
                @include('toolbox.partials.side-nav')
            </div>
            <div class="col-lg-9">
                <div class="success-div"></div>
                <div class="error-div"></div>
                <div class="ibox mb-0">
                    <div class="ibox-content">
                        <form class="form-horizontal dropzone" id="dropzoneForm"
                            action="/eol-certificates-upload" method="post" enctype=" multipart/form-data">
                            {{csrf_field()}}
                            <div class="fallback">
                                <input name="file" type="file" multiple />
                            </div>
                        </form>
                    </div>
                </div>
                <div class="success-div"></div>
                <div class="error-div"></div>
                <div class="row">
                    <div class="col-md-12 d-flex bottom-panel">
                        <div class="total-count col-auto"></div>
                        <button type="button" id="button" class="btn btn-primary col-lg-3">Upload</button>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop
@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.itad'),'helpTitle'=>config('help-links.help_titles.itad')])
@endsection

@section('after_scripts')
<link href="/css/plugins/dropzone/basic.css" rel="stylesheet">
<link href="/css/plugins/dropzone/dropzone.css" rel="stylesheet">
<script src="/js/plugins/dropzone/dropzone.js"></script>
<script>
    Dropzone.options.dropzoneForm = {
        paramName: "file", // The name that will be used to transfer the file
        uploadMultiple: true,
        parallelUploads: 500, //nos
        maxFilesize: 2, // MB
        addRemoveLinks: true,
        autoProcessQueue: false,
        thumbnailWidth: 175,
        thumbnailHeight: 175,
        acceptedFiles: 'application/pdf',
        dictDefaultMessage: "<strong>Drop files here or click to upload. </strong>",
        init: function () {
            var myDropzone = this;

            // Update selector to match your button
            $("#button").click(function (e) {
                e.preventDefault();
                myDropzone.processQueue();
            });

            myDropzone.on('sending', function (file, xhr, formData) {
                // Append all form inputs to the formData Dropzone will POST
                var data = $('#dropzoneForm').serializeArray();
                $.each(data, function (key, el) {
                    formData.append(el.name, el.value);
                });
                $('.success-div').html('');
                $('.error-div').html('');
            });
            myDropzone.on("successmultiple", function (files, response) {
                // Gets triggered when the files have successfully been sent.
                $('.success-div').html(response.success_message);
                $('.error-div').html(response.error_message);
                $('.dz-remove').hide();
            });
            myDropzone.on("errormultiple", function (files, response) {
                // Gets triggered when there was an error sending the files.
                $('.error-div').html('<div class="alert alert-danger" role="alert">Sorry, something went wrong. Try again !!</div>');
            });

            myDropzone.on("addedfile", function (file) {
                var count = myDropzone.files.length;
                $('.total-count').html('<a>Total Selected Files <span class="badge">' + count + '</span></a>');
            });


        }
    };
</script>
<style type="text/css">
    .dropzone .dz-preview .dz-image {
        width: 175px;
        height: 175px;
    }

    .dropzone .dz-preview {
        width: 175px;
    }
</style>
@stop