@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Dropbox Connection','parentSubTitle' => 'Dropbox API Credential','parentSubUrl'=>'/dropbox'
,'parentTitle' => 'Settings','parentUrl'=>'/settings'])

<div class="wrapper-content">
    <div class="container-fluid">
    	
		<div class="ibox">
			
			<div class="ibox-content ibox-content-settings">
				@include('partials.error')
				@include('partials.error-message')


				<form class="form-horizontal" method="post" action="{{route('dropbox.store')}}">

					{{csrf_field()}}

					<div class="form-group">
						<label class="col-lg-3 control-label">App Name  </label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="app_name" value="">
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">App Key  <span class="text-danger">*</span> </label>
						<div class="col-lg-6">
							<input type="password" class="form-control" name="app_key" value="">
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">App Secret  <span class="text-danger">*</span> </label>
						<div class="col-lg-6">
							<input type="password" class="form-control" name="app_secret" value="">
						</div>
					</div>
					
					<div class="form-group">
						<div class="col-lg-2">
							<button class="btn btn-primary" name="commit" type="submit">Save</button>
						</div>
					</div>

				</form>

			</div>
		</div>
		    
	</div>
</div>
@stop
@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection
@section('after_scripts')
    @include('assets.partials.scripts.common')
@stop