@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'WorkspaceOne
Credential','parentTitle'=>'Settings','parentUrl'=>'/settings'])
@inject('workspaceOneApiService','\App\Services\Integrations\WorkspaceOneApi')
<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="ibox">
            
            <div class="ibox-content">
                
                @include('partials.success')
                @include('partials.error-message')
                
                @include('settings.partials.delete-message')
                
                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                id="api-credential-table">
                
                <thead>
                    
                    <tr>
                        <th>Name</th>
                        <th>Status</th>
                        <th>URL</th>
                        <th>User Name</th>
                        <th>API Key</th>
                        <th></th>
                    </tr>
                    
                </thead>
                
                <tbody>
                    
                    <tr>
                        <td>{{$credential->api_name}}</td>
                        <td>
                            
                            <button class="btn btn-danger btn-sm" disabled="disabled">Inactive</button>
                            
                        </td>
                        <td>{{$credential->url}}</td>
                        <td>{{$credential->user_name}}</td>
                        <td>******</td>
                        <td>@can('API Credentials Edit')<a
                            href="{{route('workspace-one.edit', ['workspace_one' => $credential->id])}}"><i
                            class="icon icon-n-edit"></i></a>@endcan</td>
                        </tr>
                        
                    </tbody>
                    
                    <tfoot>
                        
                        <tr>
                            
                            <td colspan="6">
                                
                                <ul class="pagination pull-right"></ul>
                                
                            </td>
                            
                        </tr>
                        
                    </tfoot>
                    
                </table>
                
            </div>
            
        </div>
        
    </div>
    
</div>

@stop
@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection


@section('after_scripts')
@include('settings.partials.responsive-fixedheader')
@stop