@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'MobileIron Credential','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="ibox">
            
            <div class="ibox-content">
                
                @include('partials.success')
                @include('partials.error-message')
                
                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                id="api-credential-table">
                
                <thead>
                    
                    <tr>
                        <th>#</th>
                        <th>Status</th>
                        <th>URL</th>
                        <th>Username</th>
                        <th>Password</th>
                        <th>Edit</th>
                        <th>&nbsp;</th>
                    </tr>
                    
                </thead>
                
                <tbody>
                    
                    @if($credentials)
                    <tr>
                        <td>1</td>
                        <td>
                            @if ($status == 1)
                            <button class="btn btn-primary btn-sm" disabled="disabled">Active</button>
                            @else
                            <button class="btn btn-danger btn-sm" disabled="disabled">Inactive</button>
                            @endif
                        </td>
                        <td>{{$credentials->url}}</td>
                        <td>{{$credentials->user_name}}</td>
                        <td>*****</td>
                        <td>@can('API Credentials Edit')<a href="/mobile-iron/{{$credentials->id}}/edit"><i
                            class="icon icon-n-edit"></i></a>@endcan</td>
                            <td>@if ($status == 1)
                                <form action="{{route('mobile-iron-manual-sync')}}" method="post">
                                    {{csrf_field()}}
                                    <input type="submit" name="mobile_iron_sync" value="Manual Sync"
                                    class="btn btn-primary btn-sm">
                                </form>
                                @endif
                            </td>
                        </tr>
                        @else
                        <tr>
                            <td colspan="7">No Api Credentials in the system.</td>
                        </tr>
                        @endif
                        
                    </tbody>
                    
                    <tfoot>
                        
                        <tr>
                            <td colspan="7">
                                
                            </td>
                            
                        </tr>
                        
                    </tfoot>
                    
                </table>
                
            </div>
            
        </div>
        
    </div>
    
</div>


@stop
@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection


@section('after_scripts')
@include('settings.partials.responsive-fixedheader')
@stop