@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Kandji Credential','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">

                @include('partials.success')
                @include('partials.error-message')
                <div class="ibox">

                    <div class="ibox-content">


                        <div class="alert alert-danger" id="sync-error" style="display: none;"><a href="#" class="close"
                                data-dismiss="alert" aria-label="close">&times;</a></div>
                        <div class="alert alert-success" id="sync-success" style="display: none;"><a href="#"
                                class="close" data-dismiss="alert" aria-label="close">&times;</a></div>

                        <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                            id="api-credential-table">

                            <thead>

                                <tr>
                                    <th>#</th>
                                    <th>Status</th>
                                    <th>URL</th>
                                    <th>API Key</th>
                                    <th></th>
                                    <th></th>
                                </tr>

                            </thead>

                            <tbody>

                                @if($credentials)
                                <tr>
                                    <td>1</td>
                                    <td>
                                        @if ($status == 1)
                                        <button class="btn btn-primary btn-sm" disabled="disabled">Active</button>
                                        @else
                                        <button class="btn btn-danger btn-sm" disabled="disabled">Inactive</button>
                                        @endif
                                    </td>
                                    <td>{{$credentials->url}}</td>
                                    <td>*****</td>
                                    <td>@can('API Credentials Edit')<a href="/kandji/{{$credentials->id}}/edit"><i
                                                class="icon icon-n-edit"></i></a>@endcan</td>
                                    <td>@if ($status == 1)
                                        <button class="btn btn-primary btn-sm" id="kandji-sync">Manual Sync</a>
                                            @endif
                                    </td>
                                </tr>
                                @else
                                <tr>
                                    <td colspan="6">No Api Credentials in the system.</td>
                                </tr>
                                @endif

                            </tbody>

                            <tfoot>

                                <tr>
                                    <td colspan="6">

                                    </td>

                                </tr>

                            </tfoot>

                        </table>

            </div>

        </div>

    </div>

</div>


@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection


@section('after_scripts')
@include('settings.partials.responsive-fixedheader')
<script>
    $("#kandji-sync").click(function (e) {
        e.preventDefault();
        $('#kandji-sync').hide();
        $("#sync-success").html('Kandji sync started. Please wait. It may take a while.').show();
        $.ajax({
            type: "post",
            url: "/kandji-manual-sync",
            success: function (data) {
                if (data.status == 'success') {
                    $("#sync-success").html(data.message);
                } else {
                    $("#sync-success").html('').hide();
                    $("#sync-error").html(data.message).show();
                }

                $('#kandji-sync').show();
            }
        });
    });


</script>
@endsection