@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Edit Kandji Credential','parentTitle'=>'Settings','parentUrl'=>'/settings','parentSubTitle' => 'Kandji Credential','parentSubUrl'=>'/kandji'])

<div class="wrapper-content">

	<div class="container-fluid">
    	<div class="ibox">
			@include('partials.error')
			<div class="ibox-content ibox-content-settings">

				<form class="form-horizontal" method="post" action="/kandji/{{$credential->id}}">

					{{csrf_field()}}

					@method('PUT')

					<div class="form-group">
						<label class="col-lg-3 control-label">API URL</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="url" value="{{$credential->url}}">
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">API Token</label>
						<div class="col-lg-6">
							<input type="password" class="form-control" name="api_key" value="">
							<span class="help-block m-b-none">To keep the old API key, leave this empty</span>
							<span class="help-block m-b-none">You can get the API Token from <a
									href="https://support.kandji.io/api" target="__blank">here</a></span>
						</div>
					</div>

					<div class="form-group">
						<div class="col-lg-offset-3 col-lg-1">
							<button class="btn btn-primary" name="commit" type="submit">Save</button>
						</div>
					</div>

				</form>
			</div>

		</div>

	</div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection


@section('after_scripts')
@include('assets.partials.scripts.common')
@stop