@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'JumpCloud Credential','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">

                @include('partials.success')
                @include('partials.error-message')
                <div class="ibox">

                    <div class="ibox-content">


                        <div class="alert alert-danger" id="sync-error" style="display: none;"><a href="#" class="close"
                                data-dismiss="alert" aria-label="close">&times;</a></div>
                        <div class="alert alert-success" id="sync-success" style="display: none;"><a href="#"
                                class="close" data-dismiss="alert" aria-label="close">&times;</a></div>

                        <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                            id="api-credential-table">

                            <thead>

                                <tr>
                                    <th>Status</th>
                                    <th>URL</th>
                                    <th></th>
                                    {{-- <th></th> --}}
                                </tr>

                            </thead>

                            <tbody>

                                @if($credentials)
                                <tr>
                                    <td>
                                        @if ($status == 1)
                                        <button class="btn btn-primary btn-sm" disabled="disabled">Active</button>
                                        @else
                                        <button class="btn btn-danger btn-sm" disabled="disabled">Inactive</button>
                                        @endif
                                    </td>
                                    <td>{{$credentials->url}}</td>
                                    <td>@can('API Credentials Edit')<a href="/jumpcloud/{{$credentials->id}}/edit"><i
                                                class="icon icon-n-edit"></i></a>@endcan</td>
                                    {{-- <td>@if ($status == 1)
                                        <button class="btn btn-primary btn-sm" id="jumpcloud-sync">Manual Sync</a>
                                            @endif
                                    </td> --}}
                                </tr>
                                @else
                                <tr>
                                    <td colspan="3">No API Credentials in the system.</td>
                                </tr>
                                @endif

                            </tbody>

                            <tfoot>

                                <tr>
                                    <td colspan="3">

                                    </td>

                                </tr>

                            </tfoot>

                        </table>

            </div>

        </div>

    </div>

</div>


@stop

@section('after_scripts')
@include('settings.partials.responsive-fixedheader')
@include('settings.discovery-tools.jumpcloud.script')
@endsection