@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Jamf Credential','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="ibox">
            
            <div class="ibox-content">
                
                @include('partials.error-message')
                @include('partials.success')
                
                @include('partials.sync-messages')
                
                <table class="table footable  table-stripped table-hover" data-page-size="50" data-filter=#filter
                id="api-credential-table">
                
                <thead>
                    
                    <tr>
                        <th>Name</th>
                        <th>Connect</th>
                        <th>Edit</th>
                        <th>Sync</th>
                    </tr>
                    
                </thead>
                
                <tbody>
                    
                    @if($credentials)
                    <tr>
                        <td>{{$credentials->api_name}}</td>
                        <td>
                            @if ($status == 0)
                            <a href="/jamf-connect" target="_blank" class="btn btn-primary btn-sm"
                            id="connect-button">Connect</a>
                            @else
                            <a href="#" class="btn btn-primary btn-sm" disabled>Connect</a>
                            @endif
                        </td>
                        <td>
                            @can('API Credentials Edit')
                            <a href="{{route('jamf.edit', ['jamf' => $credentials->id])}}"><i class="icon icon-n-edit"></i></a>
                            @endcan
                        </td>
                            <td>
                                @if ($status != 0)
                                <button class="btn btn-primary btn-sm" id="jamf-sync">Manual Sync</button>
                                <button class="btn btn-primary btn-sm" id="jamf-sync2" disabled
                                style="display: none;"><i class="icon icon-explore-user"></i></button>
                                @else
                                <button class="btn btn-primary btn-sm" disabled>Manual Sync</button>
                                @endif
                                </td>
                            </tr>
                            @else
                            <tr>
                                <td colspan="4">No Jamf Credentials in the system.</td>
                            </tr>
                            @endif
                            
                        </tbody>
                        
                        <tfoot>
                            
                            <tr>
                                
                                <td colspan="4">
                                    
                                    <ul class="pagination pull-right"></ul>
                                    
                                </td>
                                
                            </tr>
                            
                        </tfoot>
                        
                    </table>
                    
                </div>
                
            </div>
            
        </div>
        
    </div>
    
    
    @stop
    @section('help-links')
    @include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
    @endsection
    
    @section('after_scripts')
    @include('settings.partials.responsive-fixedheader')
    @include('assets.partials.scripts.common')
    @stop