@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Edit Jamf Credential','parentTitle'=>'Settings','parentUrl'=>'/settings','parentSubTitle' => 'Jamf Credential','parentSubUrl'=>'/jamf'])

<div class="wrapper-content">
	<div class="container-fluid">
		<div class="ibox">
			<div class="ibox-content ibox-content-settings">
				@include('partials.error')
				
				<form class="form-horizontal" method="post" action="{{route('jamf.update', ['jamf' => $credential->id])}}">

					{{csrf_field()}}

					<input type="hidden" name="_method" value="PUT">

					<div class="form-group">
						<label class="col-lg-3 control-label">URL</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="url" value="{{$credential->url}}" required>
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">Client ID</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="user_name" value="{{$credential->user_name}}" required>
						</div>
					</div>

					<div  class="form-group">
						<label class="col-lg-3 control-label">Client Secret</label>
						<div class="col-lg-6">
							<input type="password" class="form-control" name="password" value="">
							<span class="help-block m-b-none">To keep the old secret, leave this empty</span>
						</div>
					</div>

					<div class="form-group">
						<div class="col-lg-offset-3 col-lg-1">
							<button class="btn btn-primary" name="commit" type="submit">Save</button>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
@stop
@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection
@section('after_scripts')
@include('assets.partials.scripts.common')
@stop
