@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Intune
Credential','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">      
        <div class="ibox">
            
            <div class="ibox-content">
                
                @include('partials.error-message')
                @if (Session::has('errorDetail'))
                <div class="alert alert-danger">
                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                    <strong>Error Detail</strong> {!! session('errorDetail') !!}
                </div>
                @endif
                @include('partials.success')
                @include('partials.sync-messages')
                
                <table class="table footable table-stripped table-hover" data-page-size="50" data-filter=#filter
                id="api-credential-table">
                
                <thead>
                    
                    <tr>
                        <th>Name</th>
                        <th>Status</th>
                        <th>Connect</th>
                        <th>Edit</th>
                        <th>Test Connection</th>
                        <th>&nbsp;</th>
                    </tr>
                    
                </thead>
                
                <tbody>
                    
                    @if($credentials)
                    <tr>
                        <td>{{$credentials->api_name}}</td>
                        <td>
                            @if($credentials->data)
                            <a href="#" class="btn btn-primary btn-sm" disabled>Active</a>
                            @else
                            <a href="#" class="btn btn-primary btn-sm" disabled>Inactive</a>
                            @endif
                        </td>
                        <td>
                            @if($credentials->data)
                            <a href="{{route('intune-signout')}}"
                            class="btn btn-primary btn-sm">Disconnect</a>
                            @else
                            <a href="{{route('intune-connect')}}" class="btn btn-primary btn-sm">Connect</a>
                            @endif
                        </td>
                        <td>
                            @can('API Credentials Edit')
                            <a href="{{route('intune.edit', ['intune' => $credentials->id])}}"><i class="icon icon-n-edit"></i></a>
                            @endcan
                        </td>
                        <td>@if($credentials->data)<a href="{{route('intune-test')}}"
                            class="btn btn-info btn-sm">Test Connection</a>@endif</td>
                            <td>@if($credentials->data)
                                <!-- <form action="{{route('intune-manual-sync')}}" method="post">
                                    {{csrf_field()}}
                                    <input type="submit" name="intune_sync" value="Manual Sync"
                                    class="btn btn-primary btn-sm">
                                </form> -->
                                <button class="btn btn-primary btn-sm" id="intune-sync">Manual Sync</button>
                                <button class="btn btn-primary btn-sm" id="intune-sync2" disabled
                                style="display: none;"><i class="icon icon-explore-user"></i></button>
                                @endif
                            </td>
                        </tr>
                        @else
                        <tr>
                            <td colspan="6">No Intune Credentials in the system.</td>
                        </tr>
                        @endif
                        
                    </tbody>
                        
                        <tfoot>
                            
                            <tr>
                                
                                <td colspan="6">
                                    
                                    <ul class="pagination pull-right"></ul>
                                    
                                </td>
                                
                            </tr>
                            
                        </tfoot>
                        
                    </table>
                    
                </div>
                
            </div>
            
        </div>
        
    </div>
    
    
    @stop
    @section('help-links')
    @include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
    @endsection
    @section('after_scripts')
    <link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
    @include('assets.partials.scripts.common')
    @stop