@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Chrome Devices','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">

        <div class="ibox">

            <div class="ibox-content">
                @include('partials.error-message')
                @include('partials.success')
                @include('partials.sync-messages')
                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                id="api-credential-table">

                <thead>

                    <tr>
                        <th>Name</th>
                        <th>Status</th>
                        <th>Sync</th>
                        <th></th>
                    </tr>

                </thead>

                <tbody>

                    <tr>

                        <td>Chrome Devices</td>
                        <td>@if ($status == 1)
                            <button class="btn btn-primary btn-sm" disabled="disabled">Active</button>
                            @else
                            <button class="btn btn-danger btn-sm" disabled="disabled">Inactive</button>
                            @endif
                        </td>

                        <td>
                            @if ($status == 1)
                            <button type="button" class="btn btn-primary manual-sync-buttons" id="chromeManualSync">Manual Sync</button>
                            @endif
                        </td>

                        <td> @can('API Credentials Edit')
                            <a href="/chrome-devices/edit"><i class="icon icon-n-edit"></i></a>
                            @endcan
                        </td>
                    </tr>

                </tbody>

                <tfoot>

                    <tr>

                        <td colspan="4">

                            <ul class="pagination pull-right"></ul>

                        </td>

                    </tr>

                </tfoot>

            </table>


        </div>

    </div>

</div>

</div>


@stop

@section('after_scripts')
@include('settings.partials.responsive-fixedheader')
<script>


    $('#connect-button').click(function () {
        $('#connect-form').show();
    });

    $('#sync-button').click(function () {
        $('#sync-button').attr("disabled", true);
    });

    $("#chromeManualSync").click(function (e) {
        e.preventDefault();
        $(".manual-sync-buttons").attr("disabled", true);
        $('#chromeManualSync').html('Chrome devices syncing.').attr("disabled", true);
        $("#sync-success").html('Chrome devices sync started. Please wait. It may take a while.').show();
        $.ajax({
            type: "post",
            url: "/chrome-devices/manual-sync",
            success: function (data) {

                $(".manual-sync-buttons").attr("disabled", false);
                $('#chromeManualSync').html('Manual Sync');
                if (data.status == 'success') {
                    $("#sync-success").html(data.message);
                    $("#sync-error").html('').hide();
                } else {
                    $("#sync-success").html('').hide();
                    $("#sync-error").html(data.message).show();
                }
            }
        });
    });
</script>
@stop