@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Create Chromebook Credential','parentTitle'=>'Settings','parentUrl'=>'/settings','parentSubTitle' => 'Chromebook Credential','parentSubUrl'=>'/chromebook'])

<div class="wrapper-content">

    <div class="container-fluid">

    	<form class="form-horizontal" method="post" action="/chrome-devices">

    		{{csrf_field()}}

	        <div class="row">

	        	@include('partials.error')

	            <div class="col-lg-12">

	            	<div class="ibox-content">

	                    <div class="form-group">
	                        <label class="col-lg-3 control-label">API Name</label>
	                        <div class="col-lg-6">
	                            <input type="text" class="form-control" name="api_name" value="{{old('api_name')}}">
	                        </div>
	                    </div>

						<div class="form-group">
	                        <label class="col-lg-3 control-label">Email</label>
	                        <div class="col-lg-6">
	                            <input type="text" class="form-control" name="email" value="{{old('user_name')}}">
	                        </div>
	                    </div>

	                    <div class="form-group">
							<div class="col-lg-offset-3 col-lg-1">
								<button class="btn btn-primary" name="commit" type="submit">Save</button>
							</div>
						</div>

	                </div>


		        </div>
		    </div>
		</form>

	</div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection

@section('after_scripts')
    @include('assets.partials.scripts.common')
@stop