@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Chrome Devices Credential Upload','parentTitle'=>'Settings','parentUrl'=>'/settings','parentSubTitle'=>'Chrome Devices','parentSubUrl'=>'/chrome-devices'])
<div class="wrapper-content"> 
    <div class="container-fluid">


        <div class="ibox">

            @include('partials.error-message')
            @include('partials.success')
            @include('partials.error')

            <div class="ibox-content">

                <!-- <p><a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html" data-target="#addApiCredential">Add New</a></p> -->
                
                <form class="form-horizontal" action="{{route('chrome-devices-save')}}" method="post" id="google-workspace-form" enctype="multipart/form-data">


                    {{csrf_field()}}
                    <div class="row">
                        <div class="col-md-12 form-group">

                            <label class="col-lg-4 control-label">Client Secret File</label>
                            <div class="col-lg-8">
                                <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                    <div class="form-control" data-trigger="fileinput">
                                        <i class="glyphicon glyphicon-file fileinput-exists"></i>
                                        <span class="fileinput-filename"></span>
                                    </div>
                                    <span class="input-group-addon btn btn-default btn-file">
                                        <span class="fileinput-new">Select file</span>
                                        <span class="fileinput-exists">Change</span>
                                        <input type="file" name="client_secrete" id="client_secrete" required />
                                    </span>
                                    <a href="#" class="input-group-addon btn btn-default fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </div>
                            </div>


                        </div>
                        <div class="col-md-12 form-group">
                            <label class="col-lg-4 control-label">Admin Email</label>
                            <div class="col-lg-8">
                                <input type="email" class="form-control" name="admin_email" value="{{old('admin_email', optional($credential)->user_name)}}" required>
                            </div>
                        </div>
                        <div class="col-md-12 form-group">
                            <label class="col-lg-4"></label>
                            <div class="col-lg-8"><a href="/google-workspace" class="btn btn-link cancel-btn">Cancel</a>

                                <button type="submit" class="btn btn-primary" id="submit_level" onclick="">Save</button>
                            </div>
                        </div>
                    </div>

                </form>

            </div>

        </div>


    </div>

</div>

@stop

@section('after_scripts')
<script>
    $('#connect-button').click(function(){
        $('#connect-form').show();
    });

    $('#sync-button').click(function(){
        $('#sync-button').attr("disabled", true);
    });
    $('.cancel-btn, close-modal').click(function(){
        $('#uploadClientSecreteModal').modal('hide');
    });
</script>
@stop

