
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/hardware-filter.js"></script>
<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/dataTables/dataTables.fixedColumns.min.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">

<script>
    $(document).ready(function () {

        @if ($errors->count() > 0)
        @if(in_array('mdm_model', $errors->keys()) || in_array('mdm_name', $errors->keys()) || in_array('make_and_model_id', $errors->keys()))
            $("#editModal").modal({ show: true });
        @else
            $("#addMapping").modal({ show: true });
        @endif
        @endif

        $('.chosen-select').chosen({ width: "100%" });

        $(".filter ").on('change', function () {

            $('#discovery-tools-mapping-filter-form').submit();
        });

        $('#submit').click(function () {
            $('#mapping-form').submit();
        });


        $.fn.serializeObject = function () {
            var obj = {};

            $.each(this.serializeArray(), function (i, o) {
                var n = o.name, v = o.value;

                obj[n] = obj[n] === undefined ? v
                : $.isArray(obj[n]) ? obj[n].concat(v)
                    : [obj[n], v];
            });

            return obj;
        };

        var table = $('.footable').DataTable({
            
            fixedHeader:true,
            "scrollX": true,
            fixedColumns: true,
            fixedColumns: {
                left: 2
            },
            "processing": true,
            
            "serverSide": true,
            "ajax": {
                "url": "/discovery-tools-hardware-mapping-data",
                "dataType": "json",
                "type": "POST",
                "data": function (result) {
                result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                {"data":'id'},
                {"data":'hardware_teqtivity'},
                {"data":'mdm_name'},
                {"data":'mdm_model'},
                {"data":'action_buttons'},
            ],
            lengthMenu: [
                [50, 100, 200, -1],
                ['50', '100', '200', 'All']
            ],
            columnDefs: [
                { orderable: false, targets: '_all' }
            ],
            "aaSorting": [],
            "dom": '<"top"i>rt<"bottom"flp><"clear">',
            "bAutoWidth": false,
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
            
        });

        $(".mapping-filter").on('change', function () {
            $('#search-form').submit();
        });

        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });

        $('.filter_mdm_model').each(function () {
            allowClear: true,
                $(this).ajaxChosen({
                    dataType: 'json',
                }, {
                    processItems: function (data) {
                        return data
                    },
                    generateUrl: function (q) {
                        return '/get-filter-fields-discovery-mappings?search=' + q;
                    },
                }, {
                    width: "100%"
                });
        });

        $(document).on("click",".btn-edit-discovery-mapping",function(e) {
            e.preventDefault();
            $("#edit-mapping-form #edit_make_and_model_id").val($(this).data('teqmodel')).trigger("chosen:updated").trigger("change");
            $("#edit-mapping-form #edit_mdm_name").val($(this).data('mdmname')).trigger("chosen:updated").trigger("change");
            var mdmModel =$(this).data('mdmmodel');
            var escapedMdmModel = mdmModel.replace(/"/g, '&quot;');
            mdmModelHtml = '<option value="'+escapedMdmModel+'">'+mdmModel+'</option>';
            $("#edit-mapping-form #edit_mdm_model").html(mdmModelHtml).trigger("chosen:updated").trigger("change");
            var rowId = $(this).data('rowid');
            $("#edit-mapping-form #hardware_mapping_id").val(rowId);
            var actionUrl = "{{ route('discovery-tools-hardware-mapping.update', ['discovery_tools_hardware_mapping' => ':id']) }}";
            // Replace ':id' with the actual rowId
            actionUrl = actionUrl.replace(':id', rowId);
            // Set the form's action attribute
            $("#edit-mapping-form").attr("action", actionUrl);
            $("#editModal").modal("show");

        });

        $(document).on("click",".btn-delete-discovery-mapping",function(e) {
            e.preventDefault();
            var rowId = $(this).data('rowid');
            $("#delete-mapping-form #delete_mapping_id").val(rowId);
            var actionUrl = "{{ route('discovery-tools-hardware-mapping.destroy', ['discovery_tools_hardware_mapping' => ':id']) }}";
            // Replace ':id' with the actual rowId
            actionUrl = actionUrl.replace(':id', rowId);
            // Set the form's action attribute
            $("#delete-mapping-form").attr("action", actionUrl);
            $("#deleteMappingModal").modal("show");

        });

    });

</script>