<div class="modal inmodal" id="editModal" tabindex="-1" role="dialog">

    <div class="modal-dialog">

        <div class="modal-content animated fadeIn">

            <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal"><span>×</span><span class="sr-only">Close</span></button>

                <h4 class="modal-title">Edit Hardware Mapping</h4>

            </div>

            <form class="form-horizontal" action="" method="post" id="edit-mapping-form">
                <div class="modal-body">

                    {{csrf_field()}}
                    @method('PUT')
                    <input type="hidden" name="id" id="hardware_mapping_id" value="{{ old('id') }}">
                    <div class="form-group">

                        <label class="col-lg-4 control-label">Hardware Standard (Teqtivity)</label>

                        <div class="col-lg-8">

                            <select class="chosen-select" id="edit_make_and_model_id" name="make_and_model_id" data-placeholder="Select">
                                @foreach($hardwareStandards as $hardwareStandard)
                                <option value="{{$hardwareStandard->id}}" @if(old('make_and_model_id') == $hardwareStandard->id) selected @endif>{{$hardwareStandard->hardware}}</option>
                                @endforeach
							</select>
                            @error('make_and_model_id')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror

                        </div>

                    </div>
                    
                    <div class="form-group">

                        <label class="col-lg-4 control-label">MDM Name</label>

                        <div class="col-lg-8">

                            <select class="chosen-select" id="edit_mdm_name"
								name="mdm_name" data-placeholder="Select">
								@foreach(config('discovery-tools-hardware-mapping.model_names') as $key => $value)
								<option value="{{ $key }}" @if(old('mdm_name') == $key) selected @endif>{{ $value }}</option>
								@endforeach
							</select>
                            @error('mdm_name')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror

                        </div>

                    </div>

                    <div class="form-group">

                        <label class="col-lg-4 control-label">Make/Model (MDM)</label>

                        <div class="col-lg-8">
                            <select class="chosen-select filter_mdm_model" id="edit_mdm_model" name="mdm_model" data-placeholder="Select">
                                @error('mdm_model')
                                    @if(old('mdm_model'))
                                        <option value="{{ str_replace('"', '&quot;',old('mdm_model')) }}">{{ old('mdm_model') }}</option>
                                    @endif
                                @enderror
                            </select>
                            @error('mdm_model')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                    </div>

                </div>

                <div class="modal-footer">

                    <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>

                    <button type="submit" class="btn btn-primary" id="update-asset">Save</button>

                </div>
            </form>

        </div>

    </div>

</div>