<div class="modal inmodal" id="addDepartmentHardwareMapping" role="dialog">

    <div class="modal-dialog modal-lg">

        <div class="modal-content animated fadeIn">

            <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal"><span>×</span><span
                        class="sr-only">Close</span></button>

                <h4 class="modal-title">Add New Hardware Kits</h4>

            </div>

            <div class="modal-body">

                <div class="alert alert-danger hardwareError" style="display: none;">
                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                    <strong>Error!</strong> <span id="error"></span>
                </div>

                <form class="form-horizontal" action="{{ route('add-hardware-kits') }}" method="post"
                    id="add-department-hardware-mapping-form">
                    <div class="row">
                        {{csrf_field()}}
                        <input type="hidden" name="action" id="action_type" value="{{ old('action') }}">
                        <div class="form-group" id="department-select-container">
                            <div class="col-lg-12">
                                <label class="col-lg-4 control-label">Department</label>

                                <div class="col-lg-8">

                                    <select id="department_id_form" name="department_id"
                                        class="form-control chosen-select">
                                        <option value=""> Select </option>
                                        @foreach ($departments as $department)
                                        <option value="{{$department->id}}" @if(old('department_id')==$department->id)
                                            selected @endif>{{ $department->name }}</option>
                                        @endforeach
                                    </select>
                                    <span class="errorText text-danger"></span>

                                </div>
                            </div>

                        </div>
                    </div>
                    <div id="row-container">
                        <div class="row hardware-kit-box">

                            <div class="col-md-4">
                                <label class="control-label">Hardware Standards</label>

                                <select name="make_and_model_id[]" class="form-control make-and-model-dropdown"
                                    data-placeholder=" Select" style="width:100% !important;">
                                    <option value="">-- HardwareStandard --</option>
                                    @foreach ($hardwareStandards as $hardwareStandard)
                                    <option data-assettype="{{$hardwareStandard->asset_type_id }}"
                                        value="{{$hardwareStandard->id}}" @if(old('make_and_model_id') &&
                                        in_array($hardwareStandard->id, old('make_and_model_id'))) selected
                                        @endif>{{ $hardwareStandard->name }}</option>
                                    @endforeach
                                </select>
                                <span class="errorText text-danger"></span>

                            </div>
                            <div class="col-md-4">
                                <label class="control-label">Tech Spec</label>

                                <select name="tech_spec_id[]" class="form-control tech-spec-dropdown"
                                    data-placeholder=" Select " style="width:100% !important;">
                                    <option value="">-- Tech Spec --</option>
                                </select>
                                <span class="errorText text-danger"></span>

                            </div>

                            <div class="col-md-3">
                                <label class="control-label ">Cost(USD)</label>
                                <div class="input-group">
                                    <span class="input-group-addon">&dollar;</span>
                                    <input type="text" name="tech_spec_cost[]"
                                        class="form-control tech-spec-value-field">
                                </div>
                                <span class="errorText text-danger"></span>
                            </div>

                            <div class="col-md-1 minus-btn">

                            </div>
                        </div>
                    </div>
                </form>

            </div>

            <div class="modal-footer">
                {{-- <div class="col-md-6"> <a href="#" id="add-hardwarekit-row" title="add another row"
                        onclick="add_hardware_mapping_row('','','')"><i class="icon icon-e-add"
                           ></i></a></div> --}}

                <div class="col-md-12 float-right">
                    <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>

                    <button type="button" class="btn btn-primary" id="submit">Save</button>
                </div>
            </div>

        </div>

    </div>

</div>