@forelse($hardWareKits as $kit)

<div class="row hardware-kit-box">

    <div class="col-md-4">
        <label class="control-label">Hardware Standards</label>

        <select name="make_and_model_id[]" class="form-control make-and-model-dropdown" data-placeholder=" Select"
            style="width:100% !important;">
            <option value="">-- HardwareStandard --</option>
            @foreach ($hardwareStandards as $hardwareStandard)
            <option data-assettype="{{$hardwareStandard->asset_type_id }}" value="{{$hardwareStandard->id}}"
                @if($hardwareStandard->id ==$kit->make_and_model_id) selected
                @endif>{{ $hardwareStandard->name }}</option>
            @endforeach
        </select>
        <span class="errorText text-danger"></span>

    </div>
    <div class="col-md-4">
        <label class="control-label">Tech Spec</label>

        <select name="tech_spec_id[]" class="form-control tech-spec-dropdown" data-placeholder=" Select "
            style="width:100% !important;">
            <option value="">-- Select --</option>
            @foreach($techSpecs->where('make_and_model_id', $kit->make_and_model_id) as $spec)
            <option value="{{ $spec->id }}" @if($spec->id ==$kit->technical_spec_id) selected @endif >{{ $spec->details
                }}</option>
            @endforeach
        </select>
        <span class="errorText text-danger"></span>

    </div>

    <div class="col-md-3">
        <label class="control-label ">Cost(USD)</label>
        <div class="input-group">
            <span class="input-group-addon">&dollar;</span>
            <input type="text" name="tech_spec_cost[]" class="form-control tech-spec-value-field"
                value="{{ $kit->cost }}">
        </div>
        <span class="errorText text-danger"></span>
    </div>

    <div class="col-md-1 minus-btn">
        @if ($loop->last)
        <a href="#" class="delete-row row-button" title="delete row of asset"><i
                class="icon icon-e-delete text-danger "></i></a>
        <a href="#" class="add-hardwarekit-row-btn" id="add-hardwarekit-row" title="add another row"
            onclick="add_hardware_mapping_row(``,``,``)"><i class="icon icon-e-add"></i></a>
        @else
        <a href="#" class="delete-row row-button" title="delete row of asset"><i
                class="icon icon-e-delete text-danger "></i></a>

        @endif
    </div>
</div>
@empty
<div class="row hardware-kit-box">

    <div class="col-md-4">
        <h3>No Hardware kits found.</h3>

    </div>
</div>
@endforelse