@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Hardware Kits','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        @include('partials.success')
        
        @include('settings.departments.partials.filter-department-hardware-mapping')
        <div class="ibox">
            <div class="ibox-content">
                
                
                @can('Hardware Standards & Technical Specs Edit')
                <p><a href="#" class="btn btn-primary add-hardware-mapping">Add New</a></p>
                <br>
                @endcan
                
                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                id="department-hardware-mapping-table">
                
                <thead>
                    
                    <tr>
                        
                        <th>#</th>
                        
                        <th>Department</th>
                        
                        <th>Hardware Standards Count</th>
                        
                        <th>Total cost</th>
                        <th></th>
                    </tr>
                    
                </thead>
                
                <tbody>
                    @include('settings.departments.partials.department-hardware-mapping')
                </tbody>
                
                <tfoot>
                    
                    <tr>
                        
                        <td colspan="5">
                            
                            <ul class="pagination pull-right"></ul>
                            
                        </td>
                        
                    </tr>
                    
                </tfoot>
                
            </table>
            
        </div>
        
    </div>
    
</div>

</div>

@include('settings.departments.partials.modal.department-hardware-mapping')
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.hardware_kits'),'helpTitle'=>config('help-links.help_titles.hardware_kits')])
@endsection

@section('after_scripts')
@include('settings.partials.responsive-fixedheader')
@include('settings.departments.partials.scripts')

<style>
    .hardware-kit-box {
        position: relative;
    }
    
    .select2-container {
        z-index: 3090;
        width: 100%;
    }
    
    .select2 {
        width: 100% !important;
    }
    
    .row-button {
        position: absolute;
        top: 30px;
    }
    
    #department_id_form_chosen {
        z-index: 5000;
    }
    
    #add-hardwarekit-row {
        float: left;
        padding-top: 30px;
        padding-left: 30px;
    }
</style>
@stop