@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Crowdstrike','parentTitle' => 'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">

        <div class="ibox">

            <div class="ibox-content">

                @include('partials.success')
                @include('partials.error-message')
                
                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                id="api-credential-table" style="text-align:left">
                
                    <thead>
                        
                        <tr>
                            <th>Name</th>
                            <th>Connection Status</th>
                            @can('API Credentials Edit')
                            <th  style="width:100px"></th>
                            @endcan
                        </tr>
                        
                    </thead>
                    
                    <tbody>
                        
                        @if($credentials)
                        <tr>
                            <td>{{$credentials->api_name}}</td>
                            @if($status == 1)
                                <td><button class="btn btn-primary"
                                    style="background-color: #5cb85c;  border-color: #4cae4c;">Active</button>
                                </td>
                            @else
                                <td><button class="btn btn-danger" style="pointer-events:none;">Inactive</button></td>
                            @endif
                            <td style="width:100px">
                                    @can('API Credentials Edit')
                                    <a href="/crowdstrike/{{$credentials->id}}/edit" class="dropbox-edit"><i class="icon icon-n-edit"></i></a>
                                    @endcan
                            </td>
                        </tr>
                        @else
                            <tr>
                                <td colspan="3">No Api Credentials in the system.</td>
                            </tr>
                        @endif
                                
                    </tbody>
                            
                    <tfoot>
                                
                        <tr>
                            <td colspan="3">
                                
                            </td>
                            
                        </tr>
                        
                    </tfoot>
                        
                </table>
                    
                    
                <div class="row">
                    <!-- <div class="col-md-12">
                        <a href="/crowdstrike/manual-sync" id="manualSync" class="btn btn-primary btn-sm"> 
                            Manual Sync
                        </a>
                        <span style="color:red;display:none" id="manualSyncValidationmsg"></span>
                    </div> -->
                    
                </div>
                      
                        
            </div>

        </div>


    </div>

</div>

@stop

@section('after_scripts')
@include('settings.partials.responsive-fixedheader')
@endsection