@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Crowdstrike Connection','parentSubTitle' => 'Crowdstrike API Credential','parentSubUrl'=>'/crowdstrike'
,'parentTitle' => 'Settings','parentUrl'=>'/settings'])

<div class="wrapper-content">

    <div class="container-fluid">
    	<div class="ibox">
	    	
            <div class="ibox-content ibox-content-settings">
                @include('partials.error')

                <form class="form-horizontal" method="post" action="/crowdstrike/{{$credential->id}}">

                    {{csrf_field()}}

                    @method('PUT')

                   <div class="form-group">
                        <label class="col-lg-3 control-label">Client ID </label>
                        <div class="col-lg-6">
                            <input type="password" class="form-control" name="app_key" value="">
                            <span class="help-block m-b-none">To keep the old app key, leave this empty</span>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-3 control-label">Client secret </label>
                        <div class="col-lg-6">
                            <input type="password" class="form-control" name="app_secret" value="">
                            <span class="help-block m-b-none">To keep the old app secret , leave this empty</span>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <div class="col-lg-2 col-lg-offset-3">

                            <button class="btn btn-primary" name="commit" type="submit">Save</button>
                        </div>
                    </div>
                </form>

            </div>
        </div>

    </div>
</div>
@stop

@section('after_scripts')
@include('assets.partials.scripts.common')
@stop