@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'AWS Cloud Assets Credential','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="ibox">
            <div class="ibox-content">
                @include('partials.error-message')
                @include('partials.success')
                @include('partials.sync-messages')
                <table class="table footable  table-stripped table-hover" data-page-size="50" data-filter="#filter" id="api-credential-table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Connect</th>
                            <th>Edit</th>
                            <th>Sync</th>
                        </tr>
                    </thead>
                    <tbody>
                    @if($credentials)
                        <tr>
                            <td>{{$credentials->api_name}}</td>
                            <td>
                                @if ($status == 0)
                                    <a href="{{ route('aws-cloud-assets.connect') }}" target="_blank" class="btn btn-primary btn-sm" id="connect-button">Connect</a>
                                @else
                                    <a href="#" class="btn btn-primary btn-sm text-white" disabled>Connect</a>
                                @endif
                            </td>
                            <td>
                            @can('API Credentials Edit')
                                <a href="{{ route('aws-cloud-assets.edit', ['aws_cloud_asset' => $credentials->id]) }}"><i class="icon icon-n-edit"></i></a></td>
                            @endcan
                            <td>
                                @if ($status != 0)
                                <button class="btn btn-primary btn-sm" id="aws-sync">Manual Sync</button>
                                <button class="btn btn-primary btn-sm" id="aws-sync2" disabled style="display: none;"><i class="icon icon-explore-user fa-spin"></i></button>
                                @else
                                    <button class="btn btn-primary btn-sm" disabled>Manual Sync</button>
                                @endif
                            </td>
                        </tr>
                        @else
                        <tr>
                            <td colspan="4">No AWS Credentials in the system.</td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@stop

@section('after_scripts')
    @include('settings.partials.responsive-fixedheader')
    @include('settings.cloud-assets.aws.scripts.script')
@stop