@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Update AWS Cloud Assets Credential','parentTitle'=>'Settings','parentUrl'=>'/settings','parentSubTitle' => 'AWS Credential','parentSubUrl'=>'/aws-cloud-assets'])

<div class="wrapper-content">
	<div class="container-fluid">
		<div class="ibox">
			<div class="ibox-content ibox-content-settings">

				@include('partials.error')

				<form class="form-horizontal" method="post" action="{{ route('aws-cloud-assets.update', ['aws_cloud_asset' => $credential->id]) }}">
					{{csrf_field()}}
                    <input type="hidden" name="_method" value="PUT">
					<div class="form-group">
						<label class="col-lg-3 control-label">Access Key ID</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="access_key" value="{{ $credential->user_name }}" required>
						</div>
					</div>
                    <div  class="form-group">
						<label class="col-lg-3 control-label">Secret Access Key</label>
						<div class="col-lg-6">
							<input type="password" class="form-control" name="secret_access_key" value="">
							<span class="help-block m-b-none">To keep the old password, leave this empty</span>
						</div>
					</div>
					<div  class="form-group">
						<label class="col-lg-3 control-label">Regions</label>
						<div class="col-lg-6">
							@php
								$selectedRegions = array_filter(explode(",", $credential->custom_data));
							@endphp
							<select class="form-control select2" multiple name="regions[]">
							@foreach ($regions as $region => $name)
								<option value="{{ $region }}" {{ (in_array($region, $selectedRegions) ? 'selected' : '') }}>{{ $name }}</option>
							@endforeach
							</select>
						</div>
					</div>

                    <div class="form-group">
						<div class="col-lg-offset-3 col-lg-1">
							<button class="btn btn-primary" name="commit" type="submit">Save</button>
						</div>
					</div>

				</form>

			</div>
		</div>
	</div>
</div>
@stop

@section('after_scripts')
@include('assets.partials.scripts.common')
@stop