@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Change Password'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-3">
                @include('settings.partials.side-nav')
            </div>
            <div class="col-lg-9">
                <div class="ibox">
                    <div class="ibox-content">
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="row">
                                @if (session('status'))
                                    <div class="alert alert-success">
                                        {{ session('status') }}
                                    </div>
                                @endif
                                </div>

                                <form class="form-horizontal" method="post" action="">
                                    {{ csrf_field() }}
                                    <div class="form-group">
                                        <label class="col-lg-4 control-label">Old Password</label>
                                        <div class="col-lg-8">
                                            <input type="password" name="current-password" class="form-control" required>
                                            @if ($errors->has('current-password'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('current-password') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>

                                    <div id="pwd-container">
                                        <div class="form-group">
                                            <label class="col-lg-4 control-label">New Password</label>
                                            <div class="col-lg-8">
                                                <input type="password" name="password" class="form-control password-input" id="password1" required>
                                                @if ($errors->has('password'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('password') }}</strong>
                                                </span>
                                                @endif
                                                <div class="pwstrength_viewport_verdict"></div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label class="col-lg-4 control-label">Confirm New Password</label>
                                        <div class="col-lg-8">
                                            <input type="password" name="password_confirmation" class="form-control" required>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <div class="col-lg-offset-4 col-lg-8">
                                            <button id="pw-submit" class="btn btn-primary" type="submit" disabled>Save</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('after_scripts')
    @include('partials.password-strength')
@stop
