@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Bulk Return','parentTitle'=>'Toolbox','parentUrl'=>'/toolbox'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            
            <div class="col-lg-3">
                @include('toolbox.partials.side-nav')
            </div>
            <div class="col-lg-9">
                <div class="ibox">
                    <div class="ibox-content">
                        
                        <div class="form-container">
                            <div class="message-div"></div>
                            <form class="file-drag form-horizontal m-b-sm dropzone d-flex"
                            action="/bulk-return/upload" method="post" id="dropzoneForm"
                            enctype="multipart/form-data">
                            {{csrf_field()}}
                            <div class="fallback">
                                <input name="file" type="file" />
                            </div>
                        </form>
                        
                        @include('partials.success')
                        @include('partials.error')
                        @include('partials.error-message')
                        <a href="/template/bulk-return.csv" class="pull-right-sm">Download Template File</a>
                    </div>
                    <h5>Assets (<span id="asset_count"></span>) </h5>
                    <form method="post" action="{{route('bulk-return.store')}}">
                        {{csrf_field()}}
                        <table id="tblview" class="footable table table-stripped table-hover" data-page-size="50"
                        data-filter=#filter>
                        <thead>
                            <tr>
                                <th>Serial #</th>
                                <th>From Status</th>
                                <th>To Status</th>
                                <th>From User/Location</th>
                                <th>To Location</th>
                                <th>Ticket #</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="7">
                                    <ul class="pagination pull-right"></ul>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                    <p class="text-right">
                        <button type="submit" name="commit" class="btn btn-primary bulk-upload-save-button" disabled>Save</button>
                    </p>
                </form>
            </div>
        </div>
        
    </div>
    
</div>
</div>
</div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.bulk_updates'),'helpTitle'=>config('help-links.help_titles.bulk_updates')])
@endsection

@section('after_scripts')
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/validator-methods.js"></script>
<script src="/js/plugins/jquery-validation/additional-methods.min.js"></script>

@include('settings.partials.file-drag-drop-script')
@stop