@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Bulk Hardware Standards','parentTitle'=>'Toolbox','parentUrl'=>'/toolbox'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-3">
                @include('toolbox.partials.side-nav')
            </div>
            <div class="col-lg-9">
                <div class="ibox">
                    <div class="ibox-content">
                        <h2>Bulk Upload</h2>
                        @include('partials.success')
                        @include('partials.error')
                        @include('partials.error-message')
                        <div class="form-container">
                            <div class="message-div"></div>
                            <form class="file-drag form-horizontal m-b-sm dropzone d-flex" action="/bulk-hardware-standards/upload" method="post" 
                            id="dropzoneForm"  enctype="multipart/form-data">
                            {{csrf_field()}}
                            <div class="fallback">
                                <input name="file" type="file" />
                            </div>
                        </form>
                        
                        
                        <a href="/template/bulk-hardware-standards-template.csv" class="pull-right-sm">Download Template File</a>
                        
                    </div>
                    
                    <h5>Hardwares (<span id="asset_count"></span>) </h5>
                    <form method="post" action="{{route('bulk-hardware-standards.store')}}">
                        {{csrf_field()}}
                        <table id="tblview" class="footable table table-stripped table-hover" data-page-size="50"
                        data-filter=#filter>
                        <thead>
                            <tr>
                                <th>Asset Type</th>
                                <th>Manufacturer</th>
                                <th>Current Hardware Standard</th>
                                <th>New Hardware Standard</th>
                                <th>Technical Specs</th>
                                <th>Status</th>
                                <th>Ticket #</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="8">
                                    <ul class="pagination pull-right"></ul>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                    <p class="text-right">
                        <button type="submit" name="commit" class="btn btn-primary bulk-upload-save-button" disabled>Save</button>
                    </p>
                </form>
            </div>
        </div>
    </div>
</div>
</div>
</div>
@stop

@section('after_scripts')
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/validator-methods.js"></script>
<script src="/js/plugins/jquery-validation/additional-methods.min.js"></script>

@include('settings.partials.file-drag-drop-script')
@stop