@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Bulk Created Date
Change','parentTitle'=>'Toolbox','parentUrl'=>'/toolbox'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-3">
                @include('settings.partials.side-nav')
            </div>
            <div class="col-lg-9">
                <div class="ibox">
                    <div class="ibox-content">
                        <form class="form-horizontal" action="/bulk-created-date-change/upload" method="post"
                            id="upload-asset-form" enctype="multipart/form-data">
                            {{csrf_field()}}
                            <div class="row">
                                <div class="col-lg-8">
                                    <div class="form-group">
                                        <label class="col-lg-4 control-label">Bulk Upload</label>
                                        <div class="col-lg-8">
                                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                                <div class="form-control" data-trigger="fileinput">
                                                    <i class="glyphicon glyphicon-file fileinput-exists"></i>
                                                    <span class="fileinput-filename"></span>
                                                </div>
                                                <span class="input-group-addon btn btn-primary btn-file">
                                                    <span class="fileinput-new">Select file</span>
                                                    <span class="fileinput-exists">Change</span>
                                                    <input type="file" name="bulk_upload_asset" id="bulk_upload_asset"
                                                        required />
                                                </span>
                                                <a href="#" class="input-group-addon btn btn-primary fileinput-exists"
                                                    data-dismiss="fileinput">Remove</a>
                                            </div>
                                            <a href="/template/bulk-created-date-change-template.csv"
                                        class="pull-right">Download Template File</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <input type="submit" class="btn btn-primary" value="Add" id="upload-button">
                                    
                                </div>
                            </div>
                        </form>
                        @include('partials.success')
                        @include('partials.error')
                        @include('partials.error-message')
                        <h5>Assets (<span id="asset_count"></span>) </h5>
                        <form method="post" action="{{route('bulk-created-date-change.store')}}">
                            {{csrf_field()}}
                            <table id="tblview" class="footable table table-stripped table-hover" data-page-size="50"
                                data-filter=#filter>
                                <thead>
                                    <tr>
                                        <th>Created Date</th>
                                        <th>Serial #</th>
                                        <th>PO #</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="4">
                                            <ul class="pagination pull-right"></ul>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                            <p class="text-right">
                                <button type="submit" name="commit" class="btn btn-primary">Save</button>
                            </p>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.bulk_updates'),'helpTitle'=>config('help-links.help_titles.bulk_updates')])
@endsection

@section('after_scripts')
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/validator-methods.js"></script>
<script src="/js/plugins/jquery-validation/additional-methods.min.js"></script>

<script>
    $("#upload-asset-form").validate({
        rules: {
            bulk_upload_asset: {
                extension: "csv",
                required: true,
            }
        },
        messages: {
            bulk_upload_asset: {
                extension: "Please upload a csv file"
            }
        }
    });

    $('#upload-asset-form').submit(function (e) {
        e.preventDefault();
        $('.alert-danger').hide();
        var formData = new FormData();
        formData.append('file', $('#bulk_upload_asset')[0].files[0]);
        $.ajax({
            type: "POST",
            url: $(this).attr('action'),
            data: formData,
            async: false,
            success: function (value) {
                var count = 0;
                if ($('#tblview tbody tr').length !== 0) {
                    count = $('#tblview tbody tr').length;
                }
                count = parseInt(count) + parseInt(value.countVal)
                $('tbody').append(value.data);
                $('#upload-asset-form').append(value.errors);
                $('#upload-asset-form').append(value.duplicate_errors);
                $('#upload-asset-form').append(value.statusChange_errors);
                $('#asset_count').text(count);
                $('#upload-asset-form')[0].reset();
            },
            cache: false,
            contentType: false,
            processData: false
        });
    });
</script>
@stop