@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'EOL Certificate - Bulk Upload
Consolidated','parentTitle'=>'Toolbox','parentUrl'=>'/toolbox'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-3">
                @include('toolbox.partials.side-nav')
            </div>
            <div class="col-lg-9">
                <div class="ibox">
                    <div class="ibox-content">
                        <div class="message-container"></div>
                        <form class="form-horizontal m-b-md " action="/bulk-certificates-upload/upload"
                            method="post" id="upload-asset-form" enctype="multipart/form-data">
                            <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                            {{csrf_field()}}
                            <div class="row">
                                <label class="col-sm-2 control-label">Certificate</label>
                                <div class="col-sm-6">
                                    <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                        <div class="form-control" data-trigger="fileinput">
                                            <i class="glyphicon glyphicon-file fileinput-exists"></i>
                                            <span class="fileinput-filename"></span>
                                        </div>
                                        <span class="input-group-addon btn btn-primary btn-file">
                                            <span class="fileinput-new">Select file</span>
                                            <span class="fileinput-exists">Change</span>
                                            <input type="file" name="upload_certificate" id="upload_certificate"
                                                required />
                                        </span>
                                        <a href="#" class="input-group-addon btn btn-primary fileinput-exists"
                                            data-dismiss="fileinput">Remove</a>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <label class="col-sm-2 control-label">Assets</label>
                                <div class="col-sm-6">
                                    <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                        <div class="form-control" data-trigger="fileinput">
                                            <i class="glyphicon glyphicon-file fileinput-exists"></i>
                                            <span class="fileinput-filename" id="fileinputName"></span>
                                        </div>
                                        <span class="input-group-addon btn btn-primary btn-file">
                                            <span class="fileinput-new">Select file</span>
                                            <span class="fileinput-exists">Change</span>
                                            <input type="file" name="bulk_upload_asset" id="bulk_upload_asset"
                                                required />
                                        </span>
                                        <a href="#" class="input-group-addon btn btn-primary fileinput-exists"
                                            data-dismiss="fileinput">Remove</a>
                                    </div>
                                    <a href="/template/bulk-certificates-upload-template.csv"
                                        class="pull-right-sm">Download Template File</a>
                                </div>
                                <div class="col-xs-4">
                                    <input type="submit" class="btn btn-primary" value="Upload" id="upload-button">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.itad'),'helpTitle'=>config('help-links.help_titles.itad')])
@endsection

@section('after_scripts')
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/validator-methods.js"></script>
<script src="/js/plugins/jquery-validation/additional-methods.min.js"></script>
<script>
    $("#upload-asset-form").validate({
        rules: {
            bulk_upload_asset: {
                extension: "csv,xlsx",
                required: true,
            },
            upload_certificate: {
                extension: "pdf",
                required: true,
            }
        },
        messages: {
            bulk_upload_asset: {
                extension: "Please upload a csv or xlsx file"
            },
            upload_certificate: {
                extension: "Please upload a pdf file"
            }
        }
    });

    $('#upload-asset-form').submit(function (e) {
        e.preventDefault();
        $('.alert-danger').hide();
        var formData = new FormData();
        formData.append('file', $('#bulk_upload_asset')[0].files[0]);
        formData.append('certificate', $('#upload_certificate')[0].files[0]);
        if ($(this).valid()) {
            $('.ajax-loader').show();
            $('#upload-button').prop('disabled', true);
            $.ajax({
                type: "POST",
                url: $(this).attr('action'),
                data: formData,
                success: function (value) {
                    $('#upload-button').prop('disabled', false);
                    $('.message-container').append(value.errors);
                    $('.message-container').append(value.duplicate_errors);
                    $('.message-container').append(value.success_message);
                    $('.message-container').append(value.error_message);
                    $('.ajax-loader').hide();
                    $('#upload-asset-form')[0].reset();
                    $("#fileinputName").text('');
                },
                cache: false,
                contentType: false,
                processData: false
            });
        }
    });
</script>
@stop