@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Bulk Asset Attribute
Update','parentTitle'=>'Toolbox','parentUrl'=>'/toolbox'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-3">
                @include('toolbox.partials.side-nav')
            </div>
            <div class="col-lg-9">
                <div class="ibox">
                    <div class="ibox-content">
                        <h2>Bulk Upload</h2>

                        <div class="form-container">
                            <div class="message-div"></div>
                            <form class="file-drag form-horizontal dropzone m-t-md m-b-md"
                                action="/bulk-asset-attribute-update/upload" method="post" id="dropzoneForm"
                                enctype="multipart/form-data">
                                {{csrf_field()}}
                                <div class="fallback">
                                    <input name="file" type="file" />
                                </div>
                            </form>

                            @include('partials.success')
                            @include('partials.error')
                            @include('partials.error-message')
                                <a href="/template/bulk-asset-attribute-update-template.csv"
                                    class="pull-right-sm">Download Template File</a>

                            <h5>Assets (<span id="asset_count"></span>) </h5>
                            <form method="post" action="">
                                {{csrf_field()}}
                                <div class="table-container">
                                    <table id="tblview" class="footable table table-stripped table-hover" data-page-size="50"
                                        data-filter=#filter>
                                        <thead>
                                            <tr>
                                                <th>Serial #</th>
                                                <th>PO #</th>
                                                <th>Created Date</th>
                                                <th>Warranty End Date</th>
                                                <th>Asset Type</th>
                                                <th>Hardware Standard</th>
                                                <th>Tech Specs</th>
                                                <th>Asset Tag #</th>
                                                <th>Asset Original Value</th>
                                                <th>Lease Start Date</th>
                                                <th>Lease End Date</th>
                                                <th>IMEI</th>
                                                <th>Carrier</th>
                                                <th>Lost Date</th>
                                                <th>End of Life Date</th>
                                                <th>Ticket #</th>
                                                <th>Asset Tracking #</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="19">
                                                    <ul class="pagination pull-right"></ul>
                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                <p class="text-right">
                                    <button type="submit" name="commit" class="btn btn-primary bulk-upload-save-button" disabled>Save</button>
                                </p>
                            </form>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.bulk_updates'),'helpTitle'=>config('help-links.help_titles.bulk_updates')])
@endsection

@section('after_scripts')
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/validator-methods.js"></script>
<script src="/js/plugins/jquery-validation/additional-methods.min.js"></script>

{{--
<script>
    $("#upload-asset-form").validate({
        rules: {
            bulk_upload_asset: {
                extension: "csv,xlsx",
                required: true,
            }
        },
        messages: {
            bulk_upload_asset: {
                extension: "Please upload a csv or xlsx file"
            }
        }
    });

    $('#upload-asset-form').submit(function (e) {
        e.preventDefault();
        $('.alert-danger').hide();
        var formData = new FormData();
        formData.append('file', $('#bulk_upload_asset')[0].files[0]);
        $.ajax({
            type: "POST",
            url: $(this).attr('action'),
            data: formData,
            async: false,
            success: function (value) {
                var count = 0;
                if ($('#tblview tbody tr').length !== 0) {
                    count = $('#tblview tbody tr').length;
                }
                count = parseInt(count) + parseInt(value.countVal)
                $('tbody').append(value.data);
                $('#upload-asset-form').append(value.errors);
                $('#upload-asset-form').append(value.duplicate_errors);
                $('#asset_count').text(count);
                $('#upload-asset-form')[0].reset();
            },
            cache: false,
            contentType: false,
            processData: false
        });
    });
</script>--}}
@include('settings.partials.file-drag-drop-script')
@stop