@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Azure SSO Configuration','parentTitle'=>'Settings','parentUrl'=>'/settings'])

<div class="wrapper-content">
	<div class="container-fluid">
		@include('partials.success')
		<div class="ibox">
			<div class="ibox-content ibox-content-settings">
				
				@include('partials.error')
                <h2>Azure SSO Configuration</h2>
                <p>
                    By integrating Azure SSO, you can streamline user authentication and provide a seamless login experience for your users.<br>
                    They can use their Azure credentials to access aaplication without the need for separate login credentials.
                </p>

                <div class="p-10" style="padding-top: 20px;clear: both;">
                    <label class="toggle-switch">
                        <input type="checkbox" id="toggleButton" @if($credential->integration_status == 1) checked @endif>
                        <span class="toggle-slider"></span>
                        </label> 
                        <span style="display: inline-block;float: left;padding-right: 15px;font-size: 15px;font-weight: 600;">Enable SSO for Azure<small style="font-size: 65%;display:block;">Add the SSO URI and Entity ID to Azure.</small></span>
                </div>
                <div class="row" style="clear:both;">
                    <div class="col-md-6">
                        <div style="padding-top: 20px; clear: both;">
                            <h3>Single Sign On URL</h3>
                            <p>You need the SSO URL to configure your SAML.</p>
                        </div>

                        <div class="row">
                            <div class="col-md-10">
                                <div class="alert alert-success">
                                    <h5>Base URL</h5>
                                    <p id="base_url">{{ url('/saml2/acs') }}</p>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <button @if(!$credential->integration_status) disabled @endif style="margin-top: 20px;" class="copy-text btn btn-primary" data-id="base_url" name="commit">Copy <i class="icon icon-copy-2"></i></button>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">

                        <div style="padding-top: 20px; clear: both;">
                            <h3>Audience URI (SP Entity ID)</h3>
                            <p>You need the Entity ID to configure your SAML.</p>
                        </div>

                        <div class="row">
                            <div class="col-md-10">
                                <div class="alert alert-success">
                                    <h5>Entity ID</h5>
                                    <p id="secure_token">{{ url('/saml2/metadata') }}</p>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <button  @if(!$credential->integration_status) disabled @endif style="margin-top: 20px;" class="copy-text btn btn-primary" data-id="secure_token" name="commit">Copy <i class="icon icon-copy-2"></i></button>
                            </div>
                        </div>
                    </div>
                    
                </div>

                <div class="row" style="clear:both;">
                    <div class="col-md-6">
                        <div style="padding-top: 20px; clear: both;">
                            <h3>Name ID format</h3>
                            <p>You need the Name ID format to configure your SAML.</p>
                        </div>

                        <div class="row">
                            <div class="col-md-10">
                                <div class="alert alert-success">
                                    <h5>Name ID format</h5>
                                    <p>Persistent</p>
                                </div>
                            </div>
                            {{-- <div class="col-md-2">
                                <button @if(!$credential->integration_status) disabled @endif style="margin-top: 20px;" class="copy-text btn btn-primary" data-id="base_url" name="commit">Copy <i class="icon icon-copy-2"></i></button>
                            </div> --}}
                        </div>
                    </div>

                    <div class="col-md-6">

                        <div style="padding-top: 20px; clear: both;">
                            <h3>Application Username</h3>
                            <p>You need the application username to configure your SAML.</p>
                        </div>

                        <div class="row">
                            <div class="col-md-10">
                                <div class="alert alert-success">
                                    <h5>Application Username</h5>
                                    <p>Email</p>
                                </div>
                            </div>
                            {{-- <div class="col-md-2">
                                <button  @if(!$credential->integration_status) disabled @endif style="margin-top: 20px;" class="copy-text btn btn-primary" data-id="secure_token" name="commit">Copy <i class="icon icon-copy-2"></i></button>
                            </div> --}}
                        </div>
                    </div>
                    
                </div>

                <div id="idp_row"  @if($credential->integration_status == 0) style="display:none;" @endif>

                    <div style="padding-top: 20px; clear: both;">
                        <h3>IDENTITY PROVIDER (IDP)</h3>
                        <p>You can set here all the parameters required to communicate with your IdP. Those information must be provided by your IdP. Please contact your SSO administrator
                            to get them</p>
                    </div>

                    @include('partials.error')
                    @include('partials.error-message')
                    
                    <p class="text-danger" id="active_msg" style="display:none;">Fill form and submit to enable sso configuration.</p>
                    
                    <form id="update_form" class="form-horizontal" style="margin-top:30px;" method="post" action="{{route('azure-sso.update', ['azure_sso' => $credential->id])}}">

                        {{csrf_field()}}

                        <input type="hidden" name="_method" value="PUT">
                        <input type="hidden" id="integration_status" name="integration_status" value="{{$credential->integration_status}}">

                        <div class="form-group">
                            <label class="col-lg-2 control-label">Issuer URL</label>
                            <div class="col-lg-6">
                                <input id="issuer_url" type="text" class="form-control" name="issuer_url" value="{{$credential->url}}" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-lg-2 control-label">Sign on URL</label>
                            <div class="col-lg-6">
                                <input type="text" class="form-control" name="sign_on_url" value="{{$credential->user_name}}" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-lg-2 control-label">Sign out URL</label>
                            <div class="col-lg-6">
                                <input type="text" class="form-control" name="sign_out_url" value="{{$credential->project}}" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-lg-2 control-label">Signing Certificate</label>
                            <div class="col-lg-6">
                                <textarea class="form-control" name="signing_certificate" rows="20" @if(empty($credential->data)) required @endif></textarea>
                                @if($credential->data)
                                <p>To keep the old signing certificate, leave this empty</p>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-lg-8 text-right" >
                                <button class="btn btn-primary" name="commit" type="submit">Save</button>
                            </div>
                        </div> 

                    </form>
                </div>
				
			</div>
			
		</div>
	</div>
</div>
@stop

@section('after_scripts')
@include('assets.partials.scripts.common')
<script>
    $(document).ready(function() {
        $(".copy-text").on('click', function(e){
            var id = $(this).attr('data-id'); 
            var temp = $("<input>");
            $("body").append(temp);
            temp.val($('#'+id).text()).select();
            document.execCommand("copy");
            temp.remove();
        });

        $('#toggleButton').change(function() {
            if ($(this).is(':checked')) {
                $("#idp_row").show('slow');
                $("#integration_status").val(1);
                $("#active_msg").show();
                $("#issuer_url").focus();
            } else {
                $("#integration_status").val(0);
                $("#update_form").submit();
            }
        });
    });
</script>
@stop