@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Create Azure Directory Credential','parentTitle'=>'Settings','parentUrl'=>'/settings','parentSubTitle' => 'Azure Directory Credential','parentSubUrl'=>'/azure-directory'])

<div class="wrapper-content">
    <div class="container-fluid">
    	<div class="row">
	    	<div class="col-lg-12">
				@include('partials.error')
	            <div class="ibox">
	                <div class="ibox-content">
				    	<form class="form-horizontal m-t-md" method="post" action="{{route('azure-directory.store')}}">

				    		{{csrf_field()}}
							<div class="row">
								<div class="col-lg-12">
									<div class="form-group">
										<label class="col-lg-3 control-label">Client Id</label>
										<div class="col-lg-8">
											<input type="text" class="form-control" name="client_id" value="" required>
										</div>
									</div>
								</div>
							</div>
							<div class="row" class="effective-row">
								<div class="col-lg-12">
									<div  class="form-group">
										<label class="col-lg-3 control-label">Client Secret</label>
										<div class="col-lg-8">
											<input type="password" class="form-control" name="client_secret" value="" required>
										</div>
									</div>
								</div>
							</div>
							<div class="row" class="effective-row">
							<div class="col-lg-12">
							<div class="form-group">
		                        <label class="col-lg-3 control-label">Tenant</label>
		                        <div class="col-lg-8">
		                            <input type="text" class="form-control" name="tenant" value="" required>
		                            <p class="help-text m-t-md">Tenant can take one of four different values:</p>
		                            <table class="table table-stripped" data-page-size="50" data-filter=#filter id="api-credential-table">

			                            <thead>

			                                <tr>
			                                    <th>Value</th>
			                                    <th>Description</th>
			                                </tr>

			                            </thead>

			                            <tbody>

											<tr>
												<td>common</td>
												<td>Allows users with both personal Microsoft accounts and work/school accounts from Azure AD to sign into the application.</td>
											</tr>
											<tr>
												<td>organizations</td>
												<td>Allows only users with work/school accounts from Azure AD to sign into the application.</td>
											</tr>
											<tr>
												<td>consumers</td>
												<td>Allows only users with personal Microsoft accounts (MSA) to sign into the application.</td>
											</tr>
											<tr>
												<td>8eaef023-2b34-4da1-9baa-8bc8c9d6a490 or contoso.onmicrosoft.com</td>
												<td>Allows only users with work/school accounts from a particular Azure AD tenant to sign into the application. Either the friendly domain name of the Azure AD tenant or the tenant's GUID identifier can be used.</td>
											</tr>
										</tbody>
									</table>
		                        </div>
		                    </div>
							</div>
							</div>
							<div class="row">
		                    <div class="form-group">
								<div class="col-lg-offset-3 col-lg-4">
									<button class="btn btn-primary" name="commit" type="submit">Save</button>
								</div>
							</div>
							</div>
						</form>

	                </div>
		        </div>
		    </div>
		</div>
	</div>
</div>


@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection


@section('after_scripts')
    @include('assets.partials.scripts.common')
@stop