@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Asset
Attribute','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        
        <div class="ibox">
            
            <div class="ibox-content">
                
                @can('Attributes Edit')
                <p><a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html"
                    data-target="#addAttributes">Add New</a></p>
                    @include('settings.partials.success-message')
                    @include('settings.partials.delete-message')
                    
                    @endcan
                    
                    <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                    id="attributes-table">
                    
                    <thead>
                        
                        <tr>
                            <th style="display: none;" ></th>
                            
                            <th>#</th>
                            
                            <th>Asset Type</th>
                            
                            <th>Attribute</th>
                            
                        </tr>
                        
                    </thead>
                    
                    <tbody>
                        
                        @foreach($attributes as $attr)
                        <tr>
                            <td style="display: none;" >{{$attr->id}}</td>
                            
                            <td>{{$loop->iteration}}</td>
                            
                            <td>{{$attr->assettype->name}}</td>
                            
                            <td>{{$attr->attribute_name}}</td>
                            
                        </tr>
                        @endforeach
                        
                    </tbody>
                    
                    <tfoot>
                        
                        <tr>
                            
                            <td colspan="4">
                                
                                <ul class="pagination pull-right"></ul>
                                
                            </td>
                            
                        </tr>
                        
                    </tfoot>
                    
                </table>
                
            </div>
            
        </div>
        
    </div>
    
</div>




<div class="modal inmodal" id="addAttributes" tabindex="-1" role="dialog">
    
    <div class="modal-dialog">
        
        <div class="modal-content animated fadeIn">
            
            <div class="modal-header">
                
                <button type="button" class="close" data-dismiss="modal"><span>×</span><span
                    class="sr-only">Close</span></button>
                    
                    <h4 class="modal-title">Add New Attributes</h4>
                    
                </div>
                
                <div class="modal-body">
                    
                    @include('partials.error')
                    
                    <form class="form-horizontal" action="" method="post" id="attributes-form">
                        
                        {{csrf_field()}}
                        
                        
                        
                        <div class="form-group">
                            
                            <label class="col-lg-4 control-label">Asset Type</label>
                            
                            <div class="col-lg-8">
                                
                                <select name="asset_type_id[]" multiple id="asset_type_id"
                                class="form-control chosen-select " data-placeholder="Select">
                                <option value="">--Select--</option>
                                @foreach(\App\Models\AssetType::orderBy('slug')->get() as $type)
                                <option value="{{$type->id}}" {{isset($selected_id) ? ($selected_id==$type->id ?
                                    'selected' : '') : (old('asset_type_id') == $type->id ? 'selected' :
                                    '')}}>{{$type->name}}</option>
                                    @endforeach
                                </select>
                                
                            </div>
                            
                        </div>
                        
                        
                        
                        <div class="form-group">
                            
                            <label class="col-lg-4 control-label">Attribute Name</label>
                            
                            <div class="col-lg-8">
                                
                                <input type="text" class="form-control" name="attribute_name"
                                value="{{old('attribute_name')}}">
                                
                            </div>
                            
                        </div>
                        
                    </form>
                    
                </div>
                
                <div class="modal-footer">
                    
                    <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>
                    
                    <button type="button" class="btn btn-primary" id="submit">Save</button>
                    
                </div>
                
            </div>
            
        </div>
        
    </div>
    
    @stop

    @section('help-links')
    @include('help.help-links',['helpLink'=>config('help-links.help_links.asset_attribute'),'helpTitle'=>config('help-links.help_titles.asset_attribute')])
    @endsection
    
    @section('after_scripts')
    
    @include('settings.attributes.attribute-script')
    
    @stop