<script src="/js/plugins/dataTables/datatables.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/dataTables/dataTables.fixedHeader.min.js"></script>
<script src="/js/plugins/tabledit/tabledit.js"></script>
<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script>

    @if ($errors -> count() > 0)
        $("#addAttributes").modal({ show: true });
    @endif

    $(document).ready(function () {
        $('.chosen-select').chosen({ width: "100%" });

        $('.modal').on('show.bs.modal', function (e) {
            $(".alert-danger").hide();
        });

        $('.footable').DataTable({
            scrollCollapse: false,
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            fixedHeader: {
                header: true,
            },
            "order": [[2, "asc"]],
            "bFilter": false,
            "bLengthChange": false,
            "bInfo": false,
        })

        $('#submit').click(function () {
            $('#attributes-form').submit();
        });

        @if (!empty(json_decode($attributes)))
            @can('Attributes Edit')
        $('#attributes-table').Tabledit({
            url: '/attribute-ajax',
            columns: {
                identifier: [0, 'id'],
                editable: [[3, 'attribute_name']]
            },
            warningClass: 'success',
            mutedClass: 'danger',
            onSuccess: function (data) {
                $('.ajax-messages').hide();
                if (data == 'success') {
                    $('#success').show();
                    $('#success p').text("Attribute updated successfully.");
                } else if (data == 'Deleted Successfully') {
                    $('#success').show();
                    $('#success p').text("Attribute deleted successfully.");
                } else if (data == 'error') {
                    $('#error').show();
                    $('#error p').text("This attribute cannot be deleted as it has assets associated with it.");
                }
                $('html, body').animate({
                    scrollTop: $("#error").offset().top
                }, 1000);
            },
            restoreButton: false
        });
        @endcan
        @endif

    });

</script>