@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Asset Type','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="ibox">
            <div class="ibox-title">

                <div class="ibox-tools">

                    <a href="#" id="export-csv" class="btn btn-primary">Export to CSV</a>
                    @can('Asset Type Edit')
                    <a href="#" class="btn btn-primary pull-right" data-toggle="modal" href="remote.html"
                    data-target="#addAssetType">Add New</a>

                    @include('settings.partials.success-message')
                    @include('settings.partials.delete-message')
                    @endcan
                </div>

            </div>
            <div class="ibox-content">

                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                id="asset-type-table">

                <thead>
                    <tr>
                        <th style="display: none;"></th>
                        <th>#</th>
                        <th>Name</th>
                        <th>Include in Asset Health Report</th>
                        <th># of Assets</th>
                    </tr>

                </thead>

                <tbody>

                    @foreach($assetTypes as $assetType)
                    <tr>
                        <td style="display: none;">{{$assetType->id}}</td>

                        <td>{{$loop->iteration}}</td>

                        <td>{{$assetType->name}}</td>
                        <td>
                            <span>
                                <input class="health-report-check" data-id="{{$assetType->id}}" type="checkbox" name="{{$assetType->id}}" {{in_array($assetType->id,$healthTestAssetTypes) ? 'checked' : ''}} >
                            </span>
                        </td>

                        <td>{{$assetType->assets_count}}</td>


                    </tr>
                    @endforeach

                </tbody>

                <tfoot>

                    <tr>

                        <td colspan="3">

                            <ul class="pagination pull-right"></ul>

                        </td>

                    </tr>

                </tfoot>

            </table>

        </div>

    </div>

</div>

</div>


<div class="modal inmodal" id="addAssetType" tabindex="-1" role="dialog">

    <div class="modal-dialog">

        <div class="modal-content animated fadeIn">

            <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal"><span>×</span><span
                    class="sr-only">Close</span></button>

                    <h4 class="modal-title">Add New Asset Type</h4>

                </div>

                <div class="modal-body">

                    @include('partials.error')

                    <form class="form-horizontal" action="" method="post" id="asset-type-form">

                        {{csrf_field()}}

                        <div class="form-group">

                            <label class="col-lg-4 control-label">Name</label>

                            <div class="col-lg-8">

                                <input type="text" class="form-control" name="asset_type" value="{{old('asset_type')}}"
                                required>

                            </div>

                        </div>

                    </form>

                </div>

                <div class="modal-footer">

                    <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>

                    <button type="button" class="btn btn-primary" id="submit">Save</button>

                </div>

            </div>

        </div>

    </div>
    @stop

    @section('help-links')
    @include('help.help-links',['helpLink'=>config('help-links.help_links.asset_type'),'helpTitle'=>config('help-links.help_titles.asset_type')])
    @endsection

    @section('after_scripts')

    @include('settings.asset-type.asset-type-script')

    @stop