<script src="/js/plugins/tabledit/tabledit.js"></script>
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/dataTables/dataTables.fixedHeader.min.js"></script>

<script>
    @if ($errors -> count() > 0)
        $("#addAssetType").modal({
            show: true
        });
    @endif

    $(document).ready(function () {

        $('.modal').on('show.bs.modal', function (e) {
            $(".alert-danger").hide();
        });

        $('.footable').DataTable({
            scrollCollapse: false,
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            fixedHeader: {
                header: true,
            },
            "order": [[2, "asc"]],
            "bFilter": false,
            "bLengthChange": false,
            "bInfo": false,
        })

        $('#submit').click(function () {
            $('#asset-type-form').submit();
        });

        @can('Asset Type Edit')
        @if ($assetTypes -> count() > 0)
            $('#asset-type-table').Tabledit({
                url: '/asset-type-ajax',
                columns: {
                    identifier: [0, 'asset_type_id'],
                    editable: [[2, 'name']]
                },
                warningClass: 'success',
                mutedClass: 'danger',
                onSuccess: function (data) {
                    $('.ajax-messages').hide();
                    if (data == 'success') {
                        $('#success').show();
                        $('#success p').text("Asset type updated successfully.");
                    } else if (data == 'Deleted Successfully') {
                        $('#success').show();
                        $('#success p').text("Asset type deleted successfully.");
                    } else if (data == 'error') {
                        $('#error').show();
                        $('#error p').text("This asset type cannot be deleted as it has assets associated with it.");
                    }
                    $('html, body').animate({
                        scrollTop: $("#error").offset().top
                    }, 1000);
                },
                restoreButton: false
            });
        @endif
        @endcan



        $('#export-csv').on('click', function (e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "/asset-type/asset-type-export",
                // data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function (result) {
                    var blob = new Blob([result]);
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                        window.navigator.msSaveBlob(blob, "asset-types.csv");
                    else {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
                        a.download = "asset-types.csv";
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });

        $('.health-report-check').on('click', function (e) {

            $('body').removeClass('pace-done').addClass('pace-running');
            $('.pace').removeClass('pace-inactive').addClass('pace-active');

            var id = $(this).data('id');
            var checked = $(this).is(':checked');

            // Checkbox is checked, send AJAX request
            $.ajax({
                url: "/set-assets-health-asset-type",
                method: 'POST', // or 'GET' depending on your route
                data: {
                    id: id,
                    checked: checked ? 1:0
                },
                success: function(response) {
                    $('body').removeClass('pace-running').addClass('pace-done');
                    $('.pace').removeClass('pace-active').addClass('pace-inactive');

                    $('#success').show();
                    $('#success p').text(response.message);
                },
                error: function(xhr, status, error) {

                }
            });
        });

    });
</script>