@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Asset Tabs','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">

        <div class="ibox">

            <div class="ibox-content">

                <form action="" method="post">

                    @include('partials.success')

                    <table class="footable  table table-stripped table-hover" data-page-size="50" data-filter=#filter
                    id="asset-tabs-table">

                    <thead>

                        <tr>

                            <th>#</th>

                            <th>Asset Types</th>

                            @foreach($assetTabs as $tab)
                            <th>
                                {{$tab->name}}
                            </th>
                            @endforeach

                        </tr>

                    </thead>

                    <tbody>

                        @foreach($assetTypes as $type)
                        <tr>

                            <td>{{$loop->iteration}}</td>

                            <td>{{$type->name}}</td>

                            @foreach($assetTabs as $tab)

                            <td>
                                <span>
                                    <input type="checkbox" name="{{$tab->slug}}-{{$type->slug}}"
                                    {{$type->hasRelationTo($tab) ? 'checked' : '' }}>
                                </span>
                            </td>

                            @endforeach

                        </tr>
                        @endforeach

                    </tbody>

                    <tfoot>

                        <tr>

                            <td colspan="{{ $assetTabs->count()+2 }}">

                                <ul class="pagination pull-right"></ul>
                                @include('settings.partials.delete-message')

                            </td>

                        </tr>

                    </tfoot>

                </table>

                <div class="row">
                    {{csrf_field()}}
                    @can('Asset Tab Edit')
                    <div class="col-md-2 col-md-offset-8"><button class="btn btn-primary"
                        type="submit">Save</button></div>
                        @endcan
                    </div>

                </form>

            </div>

        </div>

    </div>

</div>

@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.asset_tab'),'helpTitle'=>config('help-links.help_titles.asset_tab')])
@endsection

@section('after_scripts')
@include('settings.partials.responsive-fixedheader')
@stop