@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Asset Health Settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="ibox">
                <div class="ibox-content">
                    <form action="/assets-health-asset-type" method="post">
                        @include('partials.success')

                                    <table class="footable  table table-stripped table-hover"
                                        data-page-size="50" data-filter=#filter id="hardware-standard-table">

                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Asset Type</th>
                                                <th>Yes/No</th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            @foreach($assetTypes as $types)
                                                <tr>
                                                    <td>{{$loop->iteration}}</td>
                                                    <td>
                                                        {{$types->name}}
                                                    </td>
                                                    <td>
                                                        <span>
                                                            <input type="checkbox" name="{{$types->id}}" {{in_array($types->id,$healthTestAssetTypes) ? 'checked' : ''}} >
                                                        </span>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>


                            @include('settings.partials.delete-message')


                        <div class="row">
                            {{csrf_field()}}
                            <div class="col-md-2 col-md-offset-8"><button class="btn btn-w-m btn-primary"
                                type="submit">Save</button></div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>


@stop

@section('after_scripts')
